-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.5.5-10.1.30-MariaDB


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema erdb_budget
--

CREATE DATABASE IF NOT EXISTS erdb_budget;
USE erdb_budget;

--
-- Definition of table `allotment_class`
--

DROP TABLE IF EXISTS `allotment_class`;
CREATE TABLE `allotment_class` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `allotment_class`
--

/*!40000 ALTER TABLE `allotment_class` DISABLE KEYS */;
INSERT INTO `allotment_class` (`id`,`name`) VALUES 
 (1,'Capital Outlay'),
 (2,'Financial Expenses'),
 (3,'Maintenance and Other Operating Expense'),
 (4,'Personnel Services');
/*!40000 ALTER TABLE `allotment_class` ENABLE KEYS */;


--
-- Definition of table `allotment_ogmentation`
--

DROP TABLE IF EXISTS `allotment_ogmentation`;
CREATE TABLE `allotment_ogmentation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `from` int(10) unsigned NOT NULL,
  `to` int(10) unsigned NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `allotment_ogmentation`
--

/*!40000 ALTER TABLE `allotment_ogmentation` DISABLE KEYS */;
/*!40000 ALTER TABLE `allotment_ogmentation` ENABLE KEYS */;


--
-- Definition of table `allotment_received`
--

DROP TABLE IF EXISTS `allotment_received`;
CREATE TABLE `allotment_received` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `legal_basis_id` int(10) unsigned NOT NULL,
  `fund_rc_id` int(10) unsigned NOT NULL,
  `prexc_id` int(10) unsigned NOT NULL,
  `status` varchar(45) NOT NULL DEFAULT 'ACTIVE',
  `date_created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `allotment_received`
--

/*!40000 ALTER TABLE `allotment_received` DISABLE KEYS */;
/*!40000 ALTER TABLE `allotment_received` ENABLE KEYS */;


--
-- Definition of table `allotment_received_details`
--

DROP TABLE IF EXISTS `allotment_received_details`;
CREATE TABLE `allotment_received_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `first_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `second_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `third_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `fourth_amount` decimal(12,2) NOT NULL DEFAULT '0.00',
  `object_id` int(10) unsigned NOT NULL,
  `allotment_received_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_allotment_received_details_1` (`allotment_received_id`),
  CONSTRAINT `FK_allotment_received_details_1` FOREIGN KEY (`allotment_received_id`) REFERENCES `allotment_received` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `allotment_received_details`
--

/*!40000 ALTER TABLE `allotment_received_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `allotment_received_details` ENABLE KEYS */;


--
-- Definition of table `backend_user_info`
--

DROP TABLE IF EXISTS `backend_user_info`;
CREATE TABLE `backend_user_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(300) NOT NULL,
  `password` varchar(100) NOT NULL,
  `status` set('ACTIVE','INACTIVE') NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `backend_user_info`
--

/*!40000 ALTER TABLE `backend_user_info` DISABLE KEYS */;
INSERT INTO `backend_user_info` (`id`,`username`,`password`,`status`) VALUES 
 (1,'admin','e6b6afbd6d76bb5d2041542d7d2e3fac5bb05593','ACTIVE'),
 (2,'viewer','e6b6afbd6d76bb5d2041542d7d2e3fac5bb05593','ACTIVE'),
 (3,'moderator','e6b6afbd6d76bb5d2041542d7d2e3fac5bb05593','ACTIVE');
/*!40000 ALTER TABLE `backend_user_info` ENABLE KEYS */;


--
-- Definition of table `fund`
--

DROP TABLE IF EXISTS `fund`;
CREATE TABLE `fund` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(300) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fund`
--

/*!40000 ALTER TABLE `fund` DISABLE KEYS */;
INSERT INTO `fund` (`id`,`name`,`description`) VALUES 
 (1,'Regular Agency Fund - General Fund - New General Appropriations - Specific Budgets of National Government Agencies',NULL),
 (2,'Regular Agency Fund - General Fund - Continuing Appropriations - Specific Budgets of National Government Agencies',NULL);
/*!40000 ALTER TABLE `fund` ENABLE KEYS */;


--
-- Definition of table `fund_legal_basis`
--

DROP TABLE IF EXISTS `fund_legal_basis`;
CREATE TABLE `fund_legal_basis` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fund_id` int(10) unsigned NOT NULL,
  `legal_basis_id` int(10) unsigned NOT NULL,
  `year` int(10) unsigned NOT NULL,
  `status` varchar(45) NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fund_legal_basis`
--

/*!40000 ALTER TABLE `fund_legal_basis` DISABLE KEYS */;
INSERT INTO `fund_legal_basis` (`id`,`fund_id`,`legal_basis_id`,`year`,`status`) VALUES 
 (1,1,1,2018,'ACTIVE'),
 (2,2,1,2018,'ACTIVE');
/*!40000 ALTER TABLE `fund_legal_basis` ENABLE KEYS */;


--
-- Definition of table `fund_rc`
--

DROP TABLE IF EXISTS `fund_rc`;
CREATE TABLE `fund_rc` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rc_id` int(10) unsigned NOT NULL,
  `fund_id` int(10) unsigned NOT NULL,
  `year` int(10) unsigned NOT NULL,
  `status` varchar(45) NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fund_rc`
--

/*!40000 ALTER TABLE `fund_rc` DISABLE KEYS */;
/*!40000 ALTER TABLE `fund_rc` ENABLE KEYS */;


--
-- Definition of table `fund_rc_objects`
--

DROP TABLE IF EXISTS `fund_rc_objects`;
CREATE TABLE `fund_rc_objects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fund_rc_id` int(10) unsigned NOT NULL,
  `object_id` int(10) unsigned NOT NULL,
  `status` varchar(45) NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (`id`),
  KEY `FK_fund_rc_objects_1` (`fund_rc_id`),
  CONSTRAINT `FK_fund_rc_objects_1` FOREIGN KEY (`fund_rc_id`) REFERENCES `fund_rc` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `fund_rc_objects`
--

/*!40000 ALTER TABLE `fund_rc_objects` DISABLE KEYS */;
/*!40000 ALTER TABLE `fund_rc_objects` ENABLE KEYS */;


--
-- Definition of table `legal_basis`
--

DROP TABLE IF EXISTS `legal_basis`;
CREATE TABLE `legal_basis` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(300) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `legal_basis`
--

/*!40000 ALTER TABLE `legal_basis` DISABLE KEYS */;
INSERT INTO `legal_basis` (`id`,`name`,`description`) VALUES 
 (1,'RA 10964 Regular 2018 CURRENT',NULL),
 (2,'RA 10964 Regular 2017 CURRENT',NULL);
/*!40000 ALTER TABLE `legal_basis` ENABLE KEYS */;


--
-- Definition of table `object_of_expenditures`
--

DROP TABLE IF EXISTS `object_of_expenditures`;
CREATE TABLE `object_of_expenditures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(300) NOT NULL,
  `description` text NOT NULL,
  `allotment_class_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=505 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `object_of_expenditures`
--

/*!40000 ALTER TABLE `object_of_expenditures` DISABLE KEYS */;
INSERT INTO `object_of_expenditures` (`id`,`code`,`description`,`allotment_class_id`) VALUES 
 (1,'5010000000','',4),
 (2,'5010100000','Salaries and Wages',4),
 (3,'5010101000','Salaries and Wages - Regular',4),
 (4,'5010101001','Basic Salary - Civilian',4),
 (5,'5010101002','Base Pay - Military/Uniformed Personnel (MUP)',4),
 (6,'5010102000','Salaries and Wages - Casual/Contractual',4),
 (7,'5010200000','Other Compensation',4),
 (8,'5010201000','Personal Economic Relief Allowance (PERA)',4),
 (9,'5010201001','PERA - Civilian',4),
 (10,'5010201002','PERA - Military/Uniformed Personnel (MUP)',4),
 (11,'5010202000','Representation Allowance (RA)',4),
 (12,'5010203001','Transportation Allowance (TA)',4),
 (13,'5010203000','Transportation Allowance (TA)',4),
 (14,'5010203002','RATA of Sectoral/Alternate Sectoral Representatives',4),
 (15,'5010204000','Clothing/Uniform Allowance',4),
 (16,'5010204001','Clothing/Uniform Allowance - Civilian',4),
 (17,'5010204002','Shoe Allowance - Civilian',4),
 (18,'5010204003','Clothing/Uniform Allowance - Military/Uniformed Personnel (MUP)',4),
 (19,'5010204004','Clothing/Uniform Allowance - Initial - Military/Uniformed Personnel',4),
 (20,'5010204005','Clothing/Uniform Allowance - Special - Military/Uniformed Personnel (MUP)',4),
 (21,'5010204006','Clothing/Uniform Allowance - Cold Weather - Military/Uniformed Personnel (MUP)',4),
 (22,'5010204007','Clothing/Uniform Allowance - Reenlistment - Military/Uniformed Personnel (MUP)',4),
 (23,'5010204008','Clothing/Uniform Allowance - Winter - Military/Uniformed Personnel (MUP)',4),
 (24,'5010204009','Clothing/Uniform Allowance - Combat - Military/Uniformed Personnel (MUP)',4),
 (25,'5010204010','Clothing/Uniform Allowance - Maintenance Cold Weather - Military/Uniformed Personnel (MUP)',4),
 (26,'5010204011','Clothing/Uniform Allowance - Replacement - Military/Uniformed Personnel (MUP)',4),
 (27,'5010205000','Subsistence Allowance (SA)',4),
 (28,'5010205001','Subsistence Allowance - Military/Uniformed Personnel (MUP)',4),
 (29,'5010205002','Subsistence Allowance - Magna Carta Benefits for Science and Technology under R.A. 8439',4),
 (30,'5010205003','Subsistence Allowance - Magna Carta for Public Health Workers under R.A. 7305',4),
 (31,'5010205004','Subsistence Allowance - Magna Carta for Public Social Workers under R.A. 9432',4),
 (32,'5010206000','Laundry Allowance ( LA )',4),
 (33,'5010206001','Laundry Allowance - Civilian',4),
 (34,'5010206002','Laundry Allowance - Military/Uniformed Personnel (MUP)',4),
 (35,'5010206003','Laundry Allowance - Magna Carta Benefits for Science and Technology under R.A. 8439',4),
 (36,'5010206004','Laundry Allowance - Magna Carta Benefits for Public Health Workers under R.A. 7305',4),
 (37,'5010206005','Laundry Allowance - Magna Carta Benefits for Public Social Workers under R.A. 9432',4),
 (38,'5010207000','Laundry Allowance ( LA )',4),
 (39,'5010207001','Quarters Allowance - Civilian',4),
 (40,'5010207002','Quarters Allowance - Military/Uniformed Personnel (MUP)',4),
 (41,'5010207003','Quarters Allowance - Magna Carta Benefits for Science and Technology under R.A. 8439',4),
 (42,'5010207004','Quarters Allowance - Magna Carta Benefits for Public Health Workers under R.A. 7305',4),
 (43,'5010207005','Quarters Allowance - Magna Carta Benefits for Public Social Workers under R.A. 9432',4),
 (44,'5010208000','Productivity Incentive Allowance (PIA)',4),
 (45,'5010208001','Productivity Incentive Allowance - Civilian ',4),
 (46,'5010208002','Productivity Incentive Allowance - Military/Uniformed Personnel (MUP)',4),
 (47,'5010209000','Overseas Allowance (OA)',4),
 (48,'5010209001','Overseas Allowance - Civilian',4),
 (49,'5010209002','Overseas Allowance - Military/Uniformed Personnel (MUP)',4),
 (50,'5010210000','Honoraria',4),
 (51,'5010210001','Honoraria - Civilian',4),
 (52,'5010210002','Honoraria - Military/Uniformed Personnel (MUP)',4),
 (53,'5010210003','Honoraria - Magna Carta Benefits for Science and Technology under R.A. 8439',4),
 (54,'5010210004','Honoraria - Magna Carta Benefits for Public Health Social Workers under R.A.7305',4),
 (55,'5010210005','Honoraria - Magna Carta Benefits for Public Social Workers under R.A. 9432',4),
 (56,'5010211000','Hazard Pay ( HP )',4),
 (57,'5010211001','Hazard Pay',4),
 (58,'5010211002','Hazard Duty Pay - Civilian',4),
 (59,'5010211003','Hazard Duty Pay - Military/Uniformed Personnel (MUP)',4),
 (60,'5010211004','HP - Magna Carta Benefits for Science and Technology under R.A. 8439',4),
 (61,'5010211005','HP - Magna Carta Benefits for Public Health Workers under R.A. 7305',4),
 (62,'5010211006','HP - Magna Carta Benefits for Public Social Workers under R.A. 9432',4),
 (63,'5010211007','Radiation Hazard Pay not exceeding 15% of Basic Salary',4),
 (64,'5010211008','High Risk Duty Pay - Military/Uniformed Personnel (MUP)',4),
 (65,'5010211009','Hazardous Duty Pay - Military/Uniformed Personnel (MUP)',4),
 (66,'5010212000','Longevity Pay ( LP )',4),
 (67,'5010212001','Longevity Pay - Civilian',4),
 (68,'5010212002','Longevity Pay - Military/Uniformed Personnel (MUP)',4),
 (69,'5010212003','Longevity Pay - Magna Carta Benefits for Science and Technology under R.A. 8439',4),
 (70,'5010212004','Longevity Pay - Magna Carta Benefits fo Public Health Workers under R.A. 7305',4),
 (71,'5010212005','Longevity Pay - Magna Carta Benefits for Public Social Workers under R.A. 9432',4),
 (72,'5010213000','Overtime and Night Pay',4),
 (73,'5010213001','Overtime Pay',4),
 (74,'5010213002','Night-shift Differential Pay',4),
 (75,'5010214000','Year End Bonus',4),
 (76,'5010214001','Bonus - Civilian',4),
 (77,'5010214002','Bonus - Military/Uniformed Personnel (MUP)',4),
 (78,'5010215000','Cash Gift',4),
 (79,'5010215001','Cash Gift - Civilian ',4),
 (80,'5010215002','Cash Gift - Military/Uniformed Personnel (MUP)',4),
 (81,'5010299000','Other Bonuses and Allowances',4),
 (82,'5010299001','Per Diems - Civilian',4),
 (83,'5010299002','Allowance of PAO Lawyers and Employees Assigned in Night Courts - Civilian',4),
 (84,'5010299003','Allowance of Attorney\'s de Officio - Civilian',4),
 (85,'5010299004','Special Hardship Allowance - Civilian',4),
 (86,'5010299005','Private Messenger Fee - Civilian',4),
 (87,'5010299006','Inquest Allowance - Civilian',4),
 (88,'5010299007','Special Duty Allowance - Civilian',4),
 (89,'5010299008','Special Duty Allowance - Military/Uniformed Personnel (MUP)',4),
 (90,'5010299009','Special Allowance for Judges and Justices - Civilian',4),
 (91,'5010299010','Special Allowance for the Members of the Prosecution Service',4),
 (92,'5010299011','Collective Negotiation Agreement Incentive - Civilian',4),
 (93,'5010299012','Productivity Enhancement Incentive - Civilian ',4),
 (94,'5010299013','Productivity Enhancement Incentive - Military/Uniformed Personnel (MUP)',4),
 (95,'5010299014','Peformance Based Bonus - Civilian',4),
 (96,'5010299015','Peformance Based Bonus - Military/Uniformed Personnel (MUP)',4),
 (97,'5010299016','Flying Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (98,'5010299017','Special Group Term Insurance - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (99,'5010299018','Sea Duty Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (100,'5010299019','Combat Incentive Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (101,'5010299020','Reenlistment Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (102,'5010299021','Other Subsistence Allowance - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (103,'5010299022','Training Subsistence Allowance - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (104,'5010299023','Civil Disturbance Control Subsistence Allowance - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (105,'5010299024','Subsistence of Detainees - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (106,'5010299025','Hardship Allowance - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (107,'5010299026','Combat Duty Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (108,'5010299027','Incentive Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (109,'5010299028','Instructor\'s Duty Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (110,'5010299029','Reservist\'s Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (111,'5010299030','Medal of Valor Award - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (112,'5010299031','Hospitalization Expenses - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (113,'5010299032','Specialist\'s Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (114,'5010299033','Parachutist Pay - Duty Based Allowance - Military/Uniformed Personnel ( DBA-MUP )',4),
 (115,'5010299034','Provisional Allowance - Military/Uniformed Personnel',4),
 (116,'5010299035','Officers\' Allowance - Military/Uniformed Personnel',4),
 (117,'5010299036','Mid-Year Bonus - Civilian',4),
 (118,'5010299037','Mid-Year Bonus- Military/Uniformed Personnel',4),
 (119,'5010299038','Anniversary Bonus - Civilian',4),
 (120,'5010299039','Anniversary Bonus - Military/Uniformed Personnel',4),
 (121,'5010300000','',4),
 (122,'5010301000','Retirement and Life Insurance Premiums',4),
 (123,'5010302000','Pag-IBIG Contributions ',4),
 (124,'5010302001','Pag-IBIG - Civilian',4),
 (125,'5010302002','Pag-IBIG - Military/Uniformed Personnel (MUP)',4),
 (126,'5010303000','PhilHealth Contributions',4),
 (127,'5010303001','PhilHealth - Civilian',4),
 (128,'5010303002','PhilHealth - Military/Uniformed Personnel (MUP)',4),
 (129,'5010304000','Employees Compensation Insurance Premiums (ECIP)',4),
 (130,'5010304001','ECIP - Civilian',4),
 (131,'5010304002','ECIP - Military/Uniformed Personnel (MUP)',4),
 (132,'5010305000','Provident/Welfare Fund Contributions',4),
 (133,'5010400000','',4),
 (134,'5010401000','Pension Benefits',4),
 (135,'5010401001','Pension Benefits - Civilian',4),
 (136,'5010401002','Pension Benefits - Military/Uniformed Personnel (MUP)',4),
 (137,'5010401003','Pension Benefits - Veterans',4),
 (138,'5010402000','Retirement Gratuity',4),
 (139,'5010402001','Retirement Gratuity - Civilian',4),
 (140,'5010402002','Retirement Gratuity - Military/Uniformed Personnel (MUP)',4),
 (141,'5010403000','Terminal Leave Benefits ',4),
 (142,'5010403001','Terminal Leave Benefits - Civilian',4),
 (143,'5010403002','Terminal Leave Benefits - Military/Uniformed Personnel (MUP)',4),
 (144,'5010499000','Other Personnel Benefits',4),
 (145,'5010499001','Lump-sum for Creation of New Positions - Civilian',4),
 (146,'5010499002','Lump-sum for Creation of New Position - Military/Uniformed Personnel (MUP)',4),
 (147,'5010499003','Lump-sum for Reclassification of Positions',4),
 (148,'5010499004','Lump-sum for Equivalent-Record Form',4),
 (149,'5010499005','Lump-sum for Master Teachers',4),
 (150,'5010499006','Lump-sum for Compensation Adjustment ',4),
 (151,'5010499007','Lump-sum for Filling of Positions - Civilian',4),
 (152,'5010499008','Lump-sum for NBC No. 308',4),
 (153,'5010499009','Lump-sum for 4',4),
 (154,'5010499010','Lump-sum for Step Increments - Length of Service',4),
 (155,'5010499011','Lump-sum for Step Increments - Meritorious Performance',4),
 (156,'5010499012','Other Lump-sum',4),
 (157,'5010499013','Police Benefits (NAPOLCOM)',4),
 (158,'5010499014','Lump-sum for Filling of Positions - Military/Uniformed Personnel (MUP)',4),
 (159,'5010499015','Loyalty Award - Civilian',4),
 (160,'5010499099','Other Personnel Benefits',4),
 (161,'5020000000','',3),
 (162,'5020100000','',3),
 (163,'5020101000','Traveling Expenses - Local',3),
 (164,'5020102000','Traveling Expenses - Foreign',3),
 (165,'5020200000','',3),
 (166,'5020201000','Training Expenses',3),
 (167,'5020201001','ICT Training Expenses',3),
 (168,'5020201002','Training Expenses',3),
 (169,'5020202000','Scholarship Grants/Expenses',3),
 (170,'5020300000','',3),
 (171,'5020301000','Office Supplies Expenses',3),
 (172,'5020301001','ICT Office Supplies',3),
 (173,'5020301002','Office Supplies Expenses',3),
 (174,'5020302000','Accountable Forms Expenses',3),
 (175,'5020303000','Non-Accountable Forms Expenses',3),
 (176,'5020304000','Animal/Zoological Supplies Expenses',3),
 (177,'5020305000','Food Supplies Expenses',3),
 (178,'5020306000','Welfare Goods Expense',3),
 (179,'5020306000','Welfare Goods Expenses',3),
 (180,'5020307000','Drugs and Medicines Expenses',3),
 (181,'5020308000','Medical, Dental and Laboratory Supplies Expenses',3),
 (182,'5020309000','Fuel, Oil and Lubricants Expenses',3),
 (183,'5020310000','Agricultural and Marine Supplies Expenses',3),
 (184,'5020311001','Textbooks and Instructional Materials Expenses',3),
 (185,'5020311000','Textbooks and Instructional Materials Expenses',3),
 (186,'5020311002','Chalk Allowance',3),
 (187,'5020312000','Military, Police and Traffic Supplies Expenses',3),
 (188,'5020313000','Chemical and Filtering Supplies Expenses',3),
 (189,'5020321000','Semi-Expendable Machinery and Equipment Expenses',3),
 (190,'5020321000','Semi-Expendable Machinery and Equipment Expenses',3),
 (191,'5020321001','Machinery',3),
 (192,'5020321002','Office Equipment',3),
 (193,'5020321003','Information and Communications Technology Equipment',3),
 (194,'5020321004','Agricultural and Forestry Equipment',3),
 (195,'5020321005','Marine and Fishery Equipment',3),
 (196,'5020321006','Airport Equipment',3),
 (197,'5020321007','Communications Equipment',3),
 (198,'5020321008','Disaster Response and Rescue Equipment',3),
 (199,'5020321009','Military Police and Security Equipment',3),
 (200,'5020321010','Medical Equipment',3),
 (201,'5020321011','Printing Equipment',3),
 (202,'5020321012','Sports Equipment',3),
 (203,'5020321013','Technical and Scientific Equipment',3),
 (204,'5020321099','Other Machinery and Equipment',3),
 (205,'5020322000','Semi-Expendable Furniture, Fixtures and Books Expenses',3),
 (206,'5020322000','Semi-Expendable Furniture, Fixtures and Books Expenses',3),
 (207,'5020322001','Furniture and Fixtures',3),
 (208,'5020322002','Books',3),
 (209,'5020399000','Other Supplies and Materials Expenses',3),
 (210,'5020400000','',3),
 (211,'5020401000','Water Expenses',3),
 (212,'5020402000','Electricity Expenses',3),
 (213,'5020403000','Gas/Heating Expenses',3),
 (214,'5020500000','',3),
 (215,'5020501000','Postage and Courier Services',3),
 (216,'5020502000','Telephone Expenses',3),
 (217,'5020502001','Mobile',3),
 (218,'5020502002','Landline',3),
 (219,'5020503000','Internet Subscription Expenses',3),
 (220,'5020504000','Cable, Satellite, Telegraph and Radio Expenses',3),
 (221,'5020600000','',3),
 (222,'5020601001','Awards/Rewards Expenses',3),
 (223,'5020601000','Awards/Rewards Expenses',3),
 (224,'5020601002','Rewards and Incentives',3),
 (225,'5020602000','Prizes',3),
 (226,'5020700000','',3),
 (227,'5020701000','Survey Expenses',3),
 (228,'5020702000','Research, Exploration and Development Expenses',3),
 (229,'5020702001','ICT Research, Exploration and Development Expenses',3),
 (230,'5020702002','Research, Exploration and Development Expenses',3),
 (231,'5020800000','',3),
 (232,'5020801000','Demolition and Relocation Expenses',3),
 (233,'5020802000','Desilting and Dredging Expenses',3),
 (234,'5020900000','',3),
 (235,'5020901000','Generation, Transmission and Distribution Expenses',3),
 (236,'5020901001','ICT Generation, Transmission and Distribution Expenses',3),
 (237,'5020901002','Generation, Transmission and Distribution Expenses',3),
 (238,'5021000000','',3),
 (239,'5021001000','Confidential Expenses',3),
 (240,'5021002000','Intelligence Expenses',3),
 (241,'5021003000','Extraordinary and Miscellaneous Expenses',3),
 (242,'5021100000','',3),
 (243,'5021101000','Legal Services ',3),
 (244,'5021101000','Legal Services',3),
 (245,'5021102000','Auditing Services',3),
 (246,'5021103000','Consultancy Services',3),
 (247,'5021103001','ICT Consultancy Services',3),
 (248,'5021103002','Consultancy Services',3),
 (249,'5021199000','Other Professional Services',3),
 (250,'5021200000','',3),
 (251,'5021201000','Environment/Sanitary Services',3),
 (252,'5021202000','Janitorial Services',3),
 (253,'5021203000','Security Services',3),
 (254,'5021299000','Other General Services',3),
 (255,'5021299001','Other General Services - ICT Services',3),
 (256,'5021299099','Other General Services',3),
 (257,'5021300000','',3),
 (258,'5021301000','Repairs and Maintenance - Investment Property',3),
 (259,'5021302000','Repairs and Maintenance - Land Improvements',3),
 (260,'5021302001','Aquaculture Structures',3),
 (261,'5021302002','Reforestation Projects',3),
 (262,'5021302099','Other Land Improvements',3),
 (263,'5021303000','Repairs and Maintenance - Infrastructure Assets',3),
 (264,'5021303001','Road Networks',3),
 (265,'5021303002','Flood Control Systems',3),
 (266,'5021303003','Sewer Systems',3),
 (267,'5021303004','Water Supply Systems',3),
 (268,'5021303005','Power Supply Systems',3),
 (269,'5021303006','Communication Networks',3),
 (270,'5021303007','Seaport Systems',3),
 (271,'5021303008','Airport Systems',3),
 (272,'5021303009','Parks, Plazas, and Monuments',3),
 (273,'5021303099','Other Infrastructure Assets',3),
 (274,'5021304000','Repairs and Maintenance - Buildings and Other Structures',3),
 (275,'5021304001','Buildings',3),
 (276,'5021304002','School Buildings',3),
 (277,'5021304003','Hospitals and Health Centers',3),
 (278,'5021304004','Markets',3),
 (279,'5021304005','Slaughterhouses',3),
 (280,'5021304006','Hotels and Dormitories',3),
 (281,'5021304099','Other Structures',3),
 (282,'5021305000','Repairs and Maintenance - Machinery and Equipment',3),
 (283,'5021305001','Machinery',3),
 (284,'5021305002','Office Equipment',3),
 (285,'5021305003','Information and Communication Technology Equipment',3),
 (286,'5021305004','Agricultural and Forestry Equipment',3),
 (287,'5021305005','Marine and Fishery Equipment',3),
 (288,'5021305006','Airport Equipment',3),
 (289,'5021305007','Communication Equipment',3),
 (290,'5021305008','Construction and Heavy Equipment',3),
 (291,'5021305009','Disaster Response and Rescue Equipment',3),
 (292,'5021305010','Military, Police and Security Equipment',3),
 (293,'5021305011','Medical Equipment',3),
 (294,'5021305012','Printing Equipment',3),
 (295,'5021305013','Sports Equipment',3),
 (296,'5021305014','Technical and Scientific Equipment',3),
 (297,'5021305099','Other Machinery and Equipment',3),
 (298,'5021306000','Repairs and Maintenance - Transportation Equipment',3),
 (299,'5021306001','Motor Vehicles',3),
 (300,'5021306002','Trains',3),
 (301,'5021306003','Aircrafts and Aircrafts Ground Equipment',3),
 (302,'5021306004','Watercrafts',3),
 (303,'5021306099','Other Transportation Equipment',3),
 (304,'5021307000','Repairs and Maintenance - Furniture and Fixtures',3),
 (305,'5021307000','Repairs and Maintenance -  Furniture and Fixtures',3),
 (306,'5021308000','Repairs and Maintenance - Leased Assets',3),
 (307,'5021308000','Repairs and Maintenance - Leased Assets',3),
 (308,'5021308001','Buildings and Other Structures',3),
 (309,'5021308002','Machinery and Equipment',3),
 (310,'5021308003','Transportation Equipment',3),
 (311,'5021308004','ICT Machinery and Equipment',3),
 (312,'5021308099','Other Leased Assets',3),
 (313,'5021309000','Repairs and Maintenance - Leased Assets Improvements',3),
 (314,'5021309001','Land',3),
 (315,'5021309002','Buildings',3),
 (316,'5021309099','Other Leased Assets Improvements',3),
 (317,'5021310000','Restoration and Maintenance - Heritage Assets',3),
 (318,'5021310001','Historical Buildings',3),
 (319,'5021310002','Works of Arts and Archeological Specimens',3),
 (320,'5021310099','Other Heritage Assets',3),
 (321,'5021321000','Repairs and Maintenance - Semi-Expendable Machinery and Equipment',3),
 (322,'5021321000','Repairs and Maintenance - Semi-Expendable Machinery and Equipment',3),
 (323,'5021321001','Machinery',3),
 (324,'5021321002','Office Equipment',3),
 (325,'5021321003','Information and Communications Technology Equipment',3),
 (326,'5021321004','Agricultural and Forestry Equipment',3),
 (327,'5021321005','Marine and Fishery Equipment',3),
 (328,'5021321007','Communications Equipment',3),
 (329,'5021321008','Disaster Response and Rescue Equipment',3),
 (330,'5021321009','Military Police and Security Equipment',3),
 (331,'5021321010','Medical Equipment',3),
 (332,'5021321011','Printing Equipment',3),
 (333,'5021321012','Sports Equipment',3),
 (334,'5021321013','Technical and Scientific Equipment',3),
 (335,'5021321099','Other Machinery and Equipment',3),
 (336,'5021322000','Repairs and Maintenance - Semi-Expendable Furniture, Fixtures and Books',3),
 (337,'5021322000','Repairs and Maintenance - Semi-Expendable Furniture, Fixtures and Books',3),
 (338,'5021322001','Furniture and Fixtures',3),
 (339,'5021322002','Books',3),
 (340,'5021399000','Repairs and Maintenance - Other Property, Plant and Equipment',3),
 (341,'5021399001','Work/Zoo Animals',3),
 (342,'5021399099','Other Property, Plant and Equipment',3),
 (343,'5021400000','',3),
 (344,'5021401000','Subsidy to NGAs',3),
 (345,'5021402000','Financial Assistance to NGAs',3),
 (346,'5021403000','Financial Assistance to Local Government Units',3),
 (347,'5021403000','Financial Assistance to Local Government Units',3),
 (348,'5021403001','Tobacco Excise Tax (Virginia) per R.A. 7171',3),
 (349,'5021403002','Tobacco Excise Tax (Burley and Native) per R.A. 8240 / 10351',3),
 (350,'5021403003','Mining Taxes per R.A. 7160',3),
 (351,'5021403004','Royalties per R.A. 7160',3),
 (352,'5021403005','Forestry Chargers per R.A. 7160',3),
 (353,'5021403006','Fishery Charges per R.A. 7160',3),
 (354,'5021403007','Renewable Energy charges per R.A. 9513',3),
 (355,'5021403008','Income Tax Collections in ECO ZONES per R.A. 7922 and R.A. 8748',3),
 (356,'5021403009','Value Added Tax per R.A. 7643',3),
 (357,'5021403010','Value Added Tax in lieu of Franchise Tax per R.A. 7953 and R.A. 8407',3),
 (358,'5021404000','Budgetary Support to Government-Owned and/or Controlled Corporations',3),
 (359,'5021404001','Subsidy Support to Operations of GOCCs',3),
 (360,'5021404002','Road Networks',3),
 (361,'5021404003','Flood Control Systems',3),
 (362,'5021404004','Sewer Systems',3),
 (363,'5021404005','Water Supply Systems',3),
 (364,'5021404006','Power Supply Systems',3),
 (365,'5021404007','Communication Networks',3),
 (366,'5021404008','Seaport Systems',3),
 (367,'5021404009','Airport Systems',3),
 (368,'5021404010','Parks, Plazas and Monuments',3),
 (369,'5021404011','Irrigation Systems',3),
 (370,'5021404099','Other Infrastructure Assets',3),
 (371,'5021405000','Financial Assistance to NGOs/POs',3),
 (372,'5021406000','Internal Revenue Allotment',3),
 (373,'5021407000','Subsidy to Regional Offices/Staff Bureaus',3),
 (374,'5021408000','Subsidy to Operating Units',3),
 (375,'5021409000','Subsidy to Other Funds',3),
 (376,'5021499000','Subsidies - Others',3),
 (377,'5021500000','',3),
 (378,'5021501001','Taxes, Duties and Licenses',3),
 (379,'5021501000','Taxes, Duties and Licenses',3),
 (380,'5021501002','Tax Refund',3),
 (381,'5021502000','Fidelity Bond Premiums',3),
 (382,'5021503000','Insurance Expenses',3),
 (383,'5021601000','Labor and Wages',3),
 (384,'5029900000','',3),
 (385,'5029901000','Advertising Expenses',3),
 (386,'5029902000','Printing and Publication Expenses',3),
 (387,'5029903000','Representation Expenses',3),
 (388,'5029904000','Transportation and Delivery Expenses',3),
 (389,'5029905000','Rent/Lease Expenses',3),
 (390,'5029905001','Rents - Building and Structures',3),
 (391,'5029905002','Rents - Land',3),
 (392,'5029905003','Rents - Motor Vehicles',3),
 (393,'5029905004','Rents - Equipment',3),
 (394,'5029905005','Rents - Living Quarters',3),
 (395,'5029905006','Operating Lease',3),
 (396,'5029905007','Financial Lease',3),
 (397,'5029905008','Rents - ICT Machinery and Equipment',3),
 (398,'5029906000','Membership Dues and Contributions to Organizations',3),
 (399,'5029907000','Subscription Expenses',3),
 (400,'5029907001','ICT Software Subscription',3),
 (401,'5029907002','Data Center Service',3),
 (402,'5029907003','Cloud Computing Service',3),
 (403,'5029907004','Library and Other Reading Materials Subscription Expenses',3),
 (404,'5029907099','Other Subscription Expenses',3),
 (405,'5029908000','Donations',3),
 (406,'5029909000','Litigation/Acquired Assets Expenses',3),
 (407,'5029999000','Other Maintenance and Operating Expenses',3),
 (408,'5029999000','',3),
 (409,'5029999001','Website Maintenance',3),
 (410,'5029999099','Other Maintenance and Operating Expenses',3),
 (411,'5060000000','',1),
 (412,'5060100000','',1),
 (413,'5060101001','Investment in Government-Owned and/or Controlled Corporations',1),
 (414,'5060101000','Investment in Government-Owned and/or Controlled Corporations',1),
 (415,'5060101002','Road Networks',1),
 (416,'5060101003','Flood Control Systems',1),
 (417,'5060101004','Sewer Systems',1),
 (418,'5060101005','Water Supply Systems',1),
 (419,'5060101006','Power Supply Systems',1),
 (420,'5060101007','Communication Networks',1),
 (421,'5060101008','Seaport Systems',1),
 (422,'5060101009','Airport Systems',1),
 (423,'5060101010','Parks, Plazas and Monuments',1),
 (424,'5060101099','Other Infrastructure Assets',1),
 (425,'5060102000','Investment in Associates',1),
 (426,'5060200000','',1),
 (427,'5060201000','Loans Outlay - Government-Owned and/or Controlled Corporations',1),
 (428,'5060202000','Loans Outlay - Local Government Units',1),
 (429,'5060299000','Loans Outlay - Others',1),
 (430,'5060300000','',1),
 (431,'5060301000','Land and Buildings Outlay',1),
 (432,'5060301001','Investment Property - Land',1),
 (433,'5060301002','Investment Property - Buildings',1),
 (434,'5060400000','',1),
 (435,'5060401000','Land Outlay',1),
 (436,'5060401001','Land',1),
 (437,'5060402000','Land Improvements Outlay',1),
 (438,'5060402001','Aquaculture Structures',1),
 (439,'5060402002','Reforestation Projects',1),
 (440,'5060402099','Other Land Improvements',1),
 (441,'5060403000','Infrastructure Outlay',1),
 (442,'5060403001','Road Networks',1),
 (443,'5060403002','Flood Control Systems',1),
 (444,'5060403003','Sewer Systems',1),
 (445,'5060403004','Water Supply Systems',1),
 (446,'5060403005','Power Supply Systems',1),
 (447,'5060403006','Communication Networks',1),
 (448,'5060403007','Seaport Systems',1),
 (449,'5060403008','Airport Systems',1),
 (450,'5060403009','Parks, Plazas and Monuments',1),
 (451,'5060403099','Other Infrastructure Assets',1),
 (452,'5060404000','Buildings and Other Structures',1),
 (453,'5060404001','Buildings',1),
 (454,'5060404002','School Buildings',1),
 (455,'5060404003','Hospitals and Health Centers',1),
 (456,'5060404004','Markets',1),
 (457,'5060404005','Slaughterhouses',1),
 (458,'5060404006','Hostels and Dormitories',1),
 (459,'5060404007','Ground Water Monitoring Stations',1),
 (460,'5060404099','Other Structures',1),
 (461,'5060405000','Machinery and Equipment Outlay',1),
 (462,'5060405001','Machinery',1),
 (463,'5060405002','Office Equipment',1),
 (464,'5060405003','Information and Communication Technology Equipment',1),
 (465,'5060405004','Agricultural and Forestry Equipment',1),
 (466,'5060405005','Marine and Fishery Equipment',1),
 (467,'5060405006','Airport Equipment',1),
 (468,'5060405007','Communication Equipment',1),
 (469,'5060405008','Construction and Heavy Equipment',1),
 (470,'5060405009','Disaster Response and Rescue Equipment',1),
 (471,'5060405010','Military, Police and Security Equipment',1),
 (472,'5060405011','Medical Equipment',1),
 (473,'5060405012','Printing Equipment',1),
 (474,'5060405013','Sports Equipment',1),
 (475,'5060405014','Technical and Scientific Equipment',1),
 (476,'5060405015','ICT Software',1),
 (477,'5060405099','Other Machinery and Equipment',1),
 (478,'5060406000','Transportation Equipment Outlay',1),
 (479,'5060406001','Motor Vehicles',1),
 (480,'5060406002','Trains',1),
 (481,'5060406003','Aircrafts and Aircrafts Ground Equipment',1),
 (482,'5060406004','Watercrafts',1),
 (483,'5060406099','Other Transportation Equipment',1),
 (484,'5060407000','Furniture, Fixtures and Books Outlay',1),
 (485,'5060407001','Furniture and Fixtures',1),
 (486,'5060407002','Books',1),
 (487,'5060408000','Heritage Assets',1),
 (488,'5060408001','Historical Buildings',1),
 (489,'5060408002','Works of Arts and Archeological Specimens',1),
 (490,'5060408099','Other Heritage Assets',1),
 (491,'5060409000','Other Property Plant and Equipment Outlay',1),
 (492,'5060409001','Work/Zoo Animals',1),
 (493,'5060409099','Other Property, Plant and Equipment',1),
 (494,'5060500000','',1),
 (495,'5060501000','Bearer Biological Assets Outlay',1),
 (496,'5060501001','Breeding Stocks',1),
 (497,'5060501002','Livestock',1),
 (498,'5060501003','Trees, Plants and Crops',1),
 (499,'5060501004','Aquaculture',1),
 (500,'5060501099','Other Bearer Biological Assets',1),
 (501,'5060600000','',1),
 (502,'5060601000','Patents/Copyrights',1),
 (503,'5060602000','Computer Software',1),
 (504,'5060699000','Other Intangible Assets',1);
/*!40000 ALTER TABLE `object_of_expenditures` ENABLE KEYS */;


--
-- Definition of table `obligation_details`
--

DROP TABLE IF EXISTS `obligation_details`;
CREATE TABLE `obligation_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(10) unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `obligation_id` int(10) unsigned NOT NULL,
  `fund_rc_id` int(10) unsigned NOT NULL,
  `prexc_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_obligation_details_1` (`obligation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `obligation_details`
--

/*!40000 ALTER TABLE `obligation_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `obligation_details` ENABLE KEYS */;


--
-- Definition of table `obligation_disbursement`
--

DROP TABLE IF EXISTS `obligation_disbursement`;
CREATE TABLE `obligation_disbursement` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `obligation_details_id` int(10) unsigned NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ada_number` varchar(300) NOT NULL,
  `divi_number` varchar(45) NOT NULL,
  `net_amount` decimal(12,2) NOT NULL,
  `bir_amount` decimal(12,2) NOT NULL,
  `total_amount` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `obligation_disbursement`
--

/*!40000 ALTER TABLE `obligation_disbursement` DISABLE KEYS */;
/*!40000 ALTER TABLE `obligation_disbursement` ENABLE KEYS */;


--
-- Definition of table `obligation_norsa`
--

DROP TABLE IF EXISTS `obligation_norsa`;
CREATE TABLE `obligation_norsa` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `obligation_details_id` int(10) unsigned NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `norsa` decimal(12,2) NOT NULL,
  `adjusted_amount` decimal(12,2) NOT NULL,
  `status` varchar(45) NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `obligation_norsa`
--

/*!40000 ALTER TABLE `obligation_norsa` DISABLE KEYS */;
/*!40000 ALTER TABLE `obligation_norsa` ENABLE KEYS */;


--
-- Definition of table `obligations`
--

DROP TABLE IF EXISTS `obligations`;
CREATE TABLE `obligations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `obligation_no` varchar(300) NOT NULL,
  `date` date NOT NULL,
  `payee_id` int(10) unsigned NOT NULL,
  `office_id` int(10) unsigned NOT NULL,
  `address` text NOT NULL,
  `particulars` text NOT NULL,
  `quarter` int(1) unsigned NOT NULL,
  `fund_id` int(10) unsigned NOT NULL,
  `legal_basis_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `obligations`
--

/*!40000 ALTER TABLE `obligations` DISABLE KEYS */;
/*!40000 ALTER TABLE `obligations` ENABLE KEYS */;


--
-- Definition of table `office`
--

DROP TABLE IF EXISTS `office`;
CREATE TABLE `office` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `office`
--

/*!40000 ALTER TABLE `office` DISABLE KEYS */;
INSERT INTO `office` (`id`,`name`) VALUES 
 (1,'MIS'),
 (2,'Accounting'),
 (3,'Budget');
/*!40000 ALTER TABLE `office` ENABLE KEYS */;


--
-- Definition of table `payee`
--

DROP TABLE IF EXISTS `payee`;
CREATE TABLE `payee` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(300) NOT NULL,
  `description` text NOT NULL,
  `tin` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `payee`
--

/*!40000 ALTER TABLE `payee` DISABLE KEYS */;
INSERT INTO `payee` (`id`,`code`,`description`,`tin`) VALUES 
 (1,'220-766-510-000','Jose Milton Montaras','Montaras'),
 (2,'220-766-520-000','Jerry De Mesa','De Mesa');
/*!40000 ALTER TABLE `payee` ENABLE KEYS */;


--
-- Definition of table `prexc`
--

DROP TABLE IF EXISTS `prexc`;
CREATE TABLE `prexc` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(300) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
-- Dumping data for table `prexc`
--

/*!40000 ALTER TABLE `prexc` DISABLE KEYS */;
INSERT INTO `prexc` (`id`,`code`,`description`) VALUES 
 (1,'310205100001000','Forest Development');
/*!40000 ALTER TABLE `prexc` ENABLE KEYS */;


--
-- Definition of table `rc_objects`
--

DROP TABLE IF EXISTS `rc_objects`;
CREATE TABLE `rc_objects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rc_id` int(10) unsigned NOT NULL,
  `object_id` int(10) unsigned NOT NULL,
  `year` int(10) unsigned NOT NULL,
  `fund_id` int(10) unsigned NOT NULL,
  `status` varchar(45) NOT NULL DEFAULT 'ACTIVE',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `rc_objects`
--

/*!40000 ALTER TABLE `rc_objects` DISABLE KEYS */;
/*!40000 ALTER TABLE `rc_objects` ENABLE KEYS */;


--
-- Definition of table `responsibility_center`
--

DROP TABLE IF EXISTS `responsibility_center`;
CREATE TABLE `responsibility_center` (
  `id` int(10) unsigned NOT NULL,
  `code` varchar(300) NOT NULL,
  `acronym` varchar(50) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `responsibility_center`
--

/*!40000 ALTER TABLE `responsibility_center` DISABLE KEYS */;
INSERT INTO `responsibility_center` (`id`,`code`,`acronym`,`description`) VALUES 
 (2,'10-001-02-00004','ERDB','Ecosystems Research and Development Bureau'),
 (3,'10-001-02-00004-01','OD-D','Office of the Director - Division'),
 (4,'10-001-02-00004-01-001','OD-S','Office of the Director - Section'),
 (5,'10-001-02-00004-01-001-01','PMS','Project Monitoring'),
 (6,'10-001-02-00004-01-001-02','IC','International Commitment'),
 (7,'10-001-02-00004-01-002','SF','Secretary\'s Funds'),
 (8,'10-001-02-00004-01-003','AD','Asssistant Director\'s Office'),
 (9,'10-001-02-00004-01-003-01','ETRB/PTWG','ERDB Technical Review Board / Policy Technical Working Group'),
 (10,'10-001-02-00004-01-003-02','PMS','Project Monitoring and Supervision'),
 (11,'10-001-02-00004-01-003-03','GIS','Geogaphical Information System'),
 (12,'10-001-02-00004-01-004','PMISU','Planning and Management Information Service Unit'),
 (13,'10-001-02-00004-01-004-01','PPS','Planning and Programming'),
 (14,'10-001-02-00004-01-004-02','M & E','Monitoring and Evaluation'),
 (15,'10-001-02-00004-01-004-03','MIS','Management Information System'),
 (16,'10-001-02-00004-01-005','IAS','Internal Audit Service'),
 (17,'10-001-02-00004-01-005-01','LS','Legal Service'),
 (18,'10-001-02-00004-01-005-02','ART','Anti Red Tape'),
 (19,'10-001-02-00004-01-006','GASS','Genearal Administration and Support Services'),
 (20,'10-001-02-00004-01-006-01','DENR-BS','Implementation of DENR Biosafety Committee'),
 (21,'10-001-02-00004-02','FERD','Forest Ecosystems Research Division'),
 (22,'10-001-02-00004-02-001','Proj.1','Forest vulnerability and risk assessments'),
 (23,'10-001-02-00004-02-001-01','Study1','Formulation of environmental flowprocedure and criteria allocation'),
 (24,'10-001-02-00004-02-001-02','Study 2','Vulnerability assessment of selected watersheds with coastal areas in the Philippines to climate change'),
 (25,'10-001-02-00004-02-002','Proj. 2','Genetic improvement of forest tree species for quality good production'),
 (26,'10-001-02-00004-02-002-01','Study1','Germplasm collection, seed production and seedbanking of superior forest trees and development and management of database and information system for q'),
 (27,'10-001-02-00004-02-002-02','Study 2','Establishment of provenance standsand ex-situ conservation areas'),
 (28,'10-001-02-00004-02-002-03','Study 3','Progeny tests cum seedling seed orchards and clonal cum clonal seed orchard'),
 (29,'10-001-02-00004-02-002-04','Study 4','Assessment of genetic diversity of priority forest tree species through DNA analysis'),
 (30,'10-001-02-00004-02-002-05','Study 5','Macropropagation techniques of forest tree species'),
 (31,'10-001-02-00004-02-002-06','Study 6','Micropropagation techniques for priority forest tree species'),
 (32,'10-001-02-00004-02-002-07','Study 7','Evaluation of the effects of biological and organic fertilizers on the growth performance of priority forest species'),
 (33,'10-001-02-00004-02-002-08','Study 8','Application of propagation protocol developed on the growth and survival of superior indigenous forest tree species'),
 (34,'10-001-02-00004-02-003','Proj. 3','Rehabilitation and restoration of degraded areas'),
 (35,'10-001-02-00004-02-003-01','Study1','Phytoremediation measures for the rehabilitation of small-scale gold mining areas'),
 (36,'10-001-02-00004-02-003-02','Study 2','Development of biodiversity monitoring tool for mining areas under progressive rehabilitation'),
 (37,'10-001-02-00004-02-003-03','Study 3','Arthropod communities as a tool to assess soil quality and biodiversity in mining and restoration sites'),
 (38,'10-001-02-00004-02-004','Proj. 4','Environmental services of upland farms in the Philippines'),
 (39,'10-001-02-00004-02-004-01','Study1','Valuation of ecosystem services of a community-based forest management (CBFM) areas'),
 (40,'10-001-02-00004-02-005','Proj. 5','Bamboo for green environment and green economy in the Philippines (Bicol and La Union)'),
 (41,'10-001-02-00004-02-005-01','Study1','Establishment of bamboo community for small and medium-scale enterprises'),
 (42,'10-001-02-00004-02-005-02','Study 2','Rapid environmental rehabilitation and climate change impact mitigation through bamboo greening'),
 (43,'10-001-02-00004-02-006','PMS','Project monitoring and supervision'),
 (44,'10-001-02-00004-02-007-01','Study1','Pilot testing of biodiversity monitoring tool (continuing activity)'),
 (45,'10-001-02-00004-02-007-02','Study 2','Finalization of the biodiversity monitoring tool'),
 (46,'10-001-02-00004-02-007-03','Study 3','Finalization of the compilation of case studies'),
 (47,'10-001-02-00004-02-007-04','Study 4','Finalization of the policy recommendation'),
 (48,'10-001-02-00004-03','CZFERD','Coastal Zone and Freshwater Ecosystems Research Division'),
 (49,'10-001-02-00004-03-001','Proj.1','Climate change mitigation and adaptation in coastal and marine ecosystems'),
 (50,'10-001-02-00004-03-001-01','Study1','Climate change vulnerability of coastal and marine areas in priority watersheds'),
 (51,'10-001-02-00004-03-001-02','Study 2','Blue carbon sequestration in protected and unprotected sea grass meadows'),
 (52,'10-001-02-00004-03-001-03','Study 3','Dynamics of human settlements and migration patterns in the vulnerable coastal areas within priority watersheds'),
 (53,'10-001-02-00004-03-001-04','Study 4','Coastal resources inventory and formulation of research agenda of snake Island in Puerto Princesa, Palawan'),
 (54,'10-001-02-00004-03-001-05','Study 5','Productivity of seagrass meadows with and without mangrove plantation'),
 (55,'10-001-02-00004-03-001-06','Study 6','Post coral bleaching monitoring in Snake Island'),
 (56,'10-001-02-00004-03-002','Proj. 2','Bioecological profiling of mangrove in relation to climate change'),
 (57,'10-001-02-00004-03-002-01','Study1','Sediment accretion, carbon stock accumulation and greenhouse gas fluxes in Philippine mangroves'),
 (58,'10-001-02-00004-03-002-02','Study 2','Biodiversity assessment and monitoring of selected natural mangrove plantations in Region 4(Pagbilao and Catanauan, Quezon)'),
 (59,'10-001-02-00004-03-002-03','Study 3','Antrophod biodiversity in selected plantation and natural mangrove forests'),
 (60,'10-001-02-00004-03-002-04','Study 4','Growth Variation in Selected Mangrove Plantations as affected by different Habitat Conditions in the Philippines'),
 (61,'10-001-02-00004-03-003','Proj. 3','Improving sustainability of freshwater ecosystems'),
 (62,'10-001-02-00004-03-003-01','Study1','Development of management strategies for peat land'),
 (63,'10-001-02-00004-03-003-02','Study 2','Identification of Biological Indicators for Water Quailty'),
 (64,'10-001-02-00004-03-003-03','Study 3','Development of Biomonitoring Tool for Water Quality Assessment of Polluted Freshwater Ecosystems'),
 (65,'10-001-02-00004-03-003-04','Study 4','Development of a Predictive Tool for Freshwater Fish Kills using Plankton Community Structure and Dynamics'),
 (66,'10-001-02-00004-03-003-05','Study 5','Greenhouse Gas (GHG) flux measurement and carbon stock assessment of peatlands'),
 (67,'10-001-02-00004-03-004','PMS','Project Monitoring and Supervision'),
 (68,'10-001-02-00004-03-005','PMEF','Development of PMEF Station'),
 (69,'10-001-02-00004-03-006','SPF','Special Purpose Fund'),
 (70,'10-001-02-00004-03-006-01','Inter-National Conference1','2nd ASEAN Congress on Mangrove Research and Development: Managing Sustainable Mangroves in the Face of Climate Change'),
 (71,'10-001-02-00004-03-007','Proj. 4','Formulation and monitoring of Policies, Plans and Programs'),
 (72,'10-001-02-00004-03-007-01','BT','Biomonitoring Tool'),
 (73,'10-001-02-00004-04','UERD','Urban Ecosystems Research Division'),
 (74,'10-001-02-00004-04-001','Proj.1','R & D for the management and improvement of commercial and industrial zones at highly urbanized areas in the Philippines'),
 (75,'10-001-02-00004-04-001-01','Study1','Ecosystems perspective in zoning and land-use planning in highly urbanized areas'),
 (76,'10-001-02-00004-04-001-02','Study 2','Bioremediation schemes for polluted waterways and waste water reservoir at selected industrial and commercial areas'),
 (77,'10-001-02-00004-04-002','Proj. 2','Improving and enhancing healthy ecosystems for communities and settlements'),
 (78,'10-001-02-00004-04-002-01','Study1','Application of green technologies (GT) to brace communities on impacts ofurbanization'),
 (79,'10-001-02-00004-04-002-02','Study 2','Application of green technologies (GT) to brace communities on impacts of urbanization'),
 (80,'10-001-02-00004-04-002-03','Study 3','Resilience of communities to disasters and natural hazards in urban areas'),
 (81,'10-001-02-00004-04-002-04','Study 4','Adaptation Strategies of Urban Communities on Health Hazards of Industrialization and Commercialization'),
 (82,'10-001-02-00004-04-003','Proj. 3','Improving green parks and recreation areas in highly urbanized areas in the Philippines'),
 (83,'10-001-02-00004-04-003-01','Study1','Ecological assessment of parks, green spaces schools, and mini forests in urban areas'),
 (84,'10-001-02-00004-04-003-02','Study 2','TBD'),
 (85,'10-001-02-00004-04-003-03','Study 3','Psychosocial benefits and uses of green parks and open spaces in selected urban areas'),
 (86,'10-001-02-00004-04-004','PMS','Project Monitoring and Supervision'),
 (87,'10-001-02-00004-04-005','Proj. 4','Resilience of Communities to disasters and natural hazards in urban areas'),
 (88,'10-001-02-00004-04-005-01','Activity1','Coordination of project activities with DENR and LGUs (municipal and barangay levels) in 4 regions (CAR, 5, 6, and 8)'),
 (89,'10-001-02-00004-04-005-02','Activity 2','Reconnaissance and selection of sites'),
 (90,'10-001-02-00004-04-005-03','Activity 3','Pre-testing of interview schedule'),
 (91,'10-001-02-00004-04-005-04','Activity 4','Library research'),
 (92,'10-001-02-00004-04-005-05','Activity 5','Survey of urban communities including photodocumentation, GPS reading'),
 (93,'10-001-02-00004-04-005-06','Activity 6','Data processing (coding design, encoding and decoding)'),
 (94,'10-001-02-00004-04-005-07','Activity 7','Conduct of focus group discussions (FGDs) and interview with key informants'),
 (95,'10-001-02-00004-04-005-08','Activity 8','Validation of data'),
 (96,'10-001-02-00004-04-005-09','Activity 9','Pressentation of results to LGUs/conference/symposium'),
 (97,'10-001-02-00004-04-005-10','Activity10','Preparation and submission of terminal report'),
 (98,'10-001-02-00004-04-006','SPF','Special Purpose Fund'),
 (99,'10-001-02-00004-04-006-01','Inter-National Conference -1','R & D Congress on Sustainable Urbanization in the Course of ASEAN Economic'),
 (100,'10-001-02-00004-04-006-02','Inter-National Conference -2','Forum on Urban Resilience to Climate Change and Disaster Risk Reduction Management Strategies'),
 (101,'10-001-02-00004-04-007','Proj. 5','Improving Green Parks and Recreational Areas at Urbanized Areas in the Phillipines'),
 (102,'10-001-02-00004-04-007-01','Study1','Development of Guidelines for LGU Managed Urban Parks'),
 (103,'10-001-02-00004-05','LESD','Laboratory and Experimental Services Division'),
 (104,'10-001-02-00004-05-001','Proj.1','Quality Development and Management Program for Laboratoryto RDE PAPs'),
 (105,'10-001-02-00004-05-001-01','Activity1','Botany cum Herbarium'),
 (106,'10-001-02-00004-05-001-02','Activity 2','Seed Laboratory'),
 (107,'10-001-02-00004-05-001-03','Activity 3','SoilsLaboratory'),
 (108,'10-001-02-00004-05-001-04','Activity 4','Entomology Laboratory'),
 (109,'10-001-02-00004-05-001-05','Activity 5','Tissue Culture Laboratory'),
 (110,'10-001-02-00004-05-001-05-01','Study1','Micropopagation via Cotyledonary Nodes of Entada Phaseoloides (Linn.)Merr: An Endfagered Medicinal Plants in the Philippines'),
 (111,'10-001-02-00004-05-001-06','Activity 6','Forest Molecular Laboratoy'),
 (112,'10-001-02-00004-05-001-07','Activity 7','Microbiology and Pathology'),
 (113,'10-001-02-00004-05-001-08','Activity 8','ZoologyLaboratory'),
 (114,'10-001-02-00004-05-001-09','Activity 9','ChemistryLaboratory'),
 (115,'10-001-02-00004-05-001-10','Activity10','PathologyLaboratory'),
 (116,'10-001-02-00004-05-002','Proj. 2','Science-based Management of Experimental Sites & DemonstrationAreas in Support to RDE Programs/Projects'),
 (117,'10-001-02-00004-05-002-01','Activity1','Maintenance and Operation of LBES facilities'),
 (118,'10-001-02-00004-05-002-02','Activity 2','Establishment of butterfly sanctuary and garden'),
 (119,'10-001-02-00004-05-002-03','Activity 3','Conservation breedingof Sus philippensis'),
 (120,'10-001-02-00004-05-002-04','Activity 4','Maintenance and Enhancement of Existing Rattan Genebank'),
 (121,'10-001-02-00004-05-002-05','Activity 5','Maintenance of Research & Dev\'t. Zone (RDZ)'),
 (122,'10-001-02-00004-05-002-06','Activity 6','Maintenance of theBamboo and Ratan Gallery'),
 (123,'10-001-02-00004-05-002-07','Activity 7','Establishment of butterfly sanctuary and garden'),
 (124,'10-001-02-00004-05-002-08','Activity 8','Maintenance of Bamboo and Nursery Garden'),
 (125,'10-001-02-00004-05-002-09','Activity 9','Maintenance of charcoal briquetting and materials recovery facilities'),
 (126,'10-001-02-00004-05-002-10','Activity10','Monitoring of the science-based regional demonstration areas'),
 (127,'10-001-02-00004-05-002-11','Activity11','Improvement and Enhancement of LBES'),
 (128,'10-001-02-00004-05-002-12','Activity12','Improvement and Enhancement of RDZ'),
 (129,'10-001-02-00004-05-002-13','Activity13','Installation of Solar Panel'),
 (130,'10-001-02-00004-05-002-14','Activity14','Construction of perimeter fence'),
 (131,'10-001-02-00004-05-002-15','Activity15','Maintenance of Butterfly Sanctuary'),
 (132,'10-001-02-00004-05-002-16','Activity16','Maintenance of Butterfly Garden at the back of ERDB'),
 (133,'10-001-02-00004-05-003','PMS','Project Monitoring and Supervision'),
 (134,'10-001-02-00004-05-004','Proj. 3','Production and Analysis of Frass from Polystyrene-Fed Yellow Mwalworms (Tenebrio molitor Linnaeus)'),
 (135,'10-001-02-00004-06','TTD','Technology Transfer Division'),
 (136,'10-001-02-00004-06-001','Proj.1','Packaging of ENR Technologies for Extension and Dissemination'),
 (137,'10-001-02-00004-06-001-01','Activity1','Technology assessment, classification and characterization'),
 (138,'10-001-02-00004-06-001-02','Activity 2','Processing of assessed technologies for specific end-users'),
 (139,'10-001-02-00004-06-001-03','Activity 3','Financial Feasibility of Clonal Propagation Technology Adopted by Selected SUCs in Luzon'),
 (140,'10-001-02-00004-06-001-04','Activity 4','Sustainable livelihood for General Nakar, Quezon'),
 (141,'10-001-02-00004-06-002','Proj. 2','Promotion and Dissemination of Technologies for Sustainable ENR Management'),
 (142,'10-001-02-00004-06-002-01','Activity1','Production of IEC materials'),
 (143,'10-001-02-00004-06-002-02','Activity 2','IEC campaign for promotion of ENR technologies'),
 (144,'10-001-02-00004-06-002-03','Activity 3','Capacity building for ERDB clients'),
 (145,'10-001-02-00004-06-002-04','Activity 4','Participatory extension of ENR Technologies through PARTNER-BOND Strategy'),
 (146,'10-001-02-00004-06-002-05','Activity 5','Promotion of ENR technologies through demonstration areas'),
 (147,'10-001-02-00004-06-003','Proj. 3','Monitoring and Post-Evaluation of Transferred ENR Technologies'),
 (148,'10-001-02-00004-06-003-01','Activity1','Monitoring of ENR technology transfer extension activities'),
 (149,'10-001-02-00004-06-003-02','Activity 2','Post-evaluation of transferred ENR technologies using the evaluation to module'),
 (150,'10-001-02-00004-06-003-03','Activity 3','Client-based satisfaction survey of transferred ENR technologies'),
 (151,'10-001-02-00004-06-004','Proj. 4','Financial Evaluation of ENR Technologies adopted by selected upland and coastal communities in the Philippines'),
 (152,'10-001-02-00004-06-004-03','Activity 3','IEC Campaign'),
 (153,'10-001-02-00004-06-005','STO','Production of technical publication of ENR'),
 (154,'10-001-02-00004-06-005-01','Activity1','Circulation of Publication, preparation and distribution of Publication'),
 (155,'10-001-02-00004-06-005-02','Activity 2','ERDB annual Report'),
 (156,'10-001-02-00004-06-005-03','Activity 3','Audio Visual Services PMS'),
 (157,'10-001-02-00004-06-005-04','Activity 4','Library service'),
 (158,'10-001-02-00004-06-005-05','Activity 5','Senior Citizen Program'),
 (159,'10-001-02-00004-06-005-06','Activity 6','Sylvatrop'),
 (160,'10-001-02-00004-06-005-07','Activity 7','Canopy International'),
 (161,'10-001-02-00004-06-005-08','Activity 8','RISE and Info Journal'),
 (162,'10-001-02-00004-06-005-09','Activity 9','Monthly Technical Seminar Series PMS'),
 (163,'10-001-02-00004-06-006','PMS','Project Monitoring and Supervision'),
 (164,'10-001-02-00004-06-007','NBW','National Bio-Technology Week'),
 (165,'10-001-02-00004-06-008','Proj. 5','ENR technology Extension Project'),
 (166,'10-001-02-00004-06-008-01','Activity1','Technology needs assessment'),
 (167,'10-001-02-00004-06-008-02','Activity 2','Capacity-building for ERDB clients'),
 (168,'10-001-02-00004-06-008-03','Activity 3','IEC-campaign'),
 (169,'10-001-02-00004-06-008-04','Activity 4','Community mobilization for ENR Technology adoptation/utilization'),
 (170,'10-001-02-00004-06-008-05','Activity 5','Communication Planning'),
 (171,'10-001-02-00004-07','AFMD','Administrative, Financial and Management Division'),
 (172,'10-001-02-00004-07-001','AS','Accounting Section'),
 (173,'10-001-02-00004-07-002','BCS','Budget and Cash Section'),
 (174,'10-001-02-00004-07-003','GSPS','General Services and Property Section'),
 (175,'10-001-02-00004-07-004','PRS','Personnel and Records Section'),
 (176,'10-001-02-00004-07-005','MS','Management Section'),
 (177,'10-001-02-00004-08','NGP','National Greening Program'),
 (178,'10-001-02-00004-08-001','Proj.1','Production of quality planting materials of different indigenous forest tree species'),
 (179,'10-001-02-00004-08-002','Proj. 2','Maintenance of Seed Production Areas (SPA) (including seed collection)'),
 (180,'10-001-02-00004-08-003','Proj. 3','Rehabilitation and maintenance of the Pagbilao Mangrove Biodiversity and Demo Area'),
 (181,'10-001-02-00004-08-004','Proj. 4','Mass Production, Product Promotion and Marketing of Mycorrhizal Inoculants for the National Greening Program'),
 (182,'10-001-02-00004-08-005','Proj. 5','Establishment and Maintenance/ Operationalization of Forest Tree Seed Centers (FTSC'),
 (183,'10-001-02-00004-08-006','Proj. 6','Conduct of baseline/benchmark data on Socio-economic, Biological, Physical and spatial Component of NGP sites nationwide'),
 (184,'10-001-02-00004-08-007','Proj. 7','Project Monitoring and Supervision (PMS) relative to NGP'),
 (185,'10-001-02-00004-08-008','Proj. 8','Plantation Development'),
 (186,'10-001-02-00004-08-009','Activity1','Procurement of Equipment'),
 (187,'10-001-02-00004-08-009-01','Activity1','FTSC-Office Equipment'),
 (188,'10-001-02-00004-08-010','Activity 2','Rehabilitation of Existing Clonal Facilities'),
 (189,'10-001-02-00004-08-011','Activity 3','Monitoring and Evaluation'),
 (190,'10-001-02-00004-08-011-01','RS','Rental Services'),
 (191,'10-001-02-00004-08-011-02','CN','Clonal Nurseries'),
 (192,'10-001-02-00004-08-011-03','SPA','SPA/IPT'),
 (193,'10-001-02-00004-08-012','Proj. 9','Clonal Nursery and Production of Quality Planting Materials of Premium and Indigenous Forest Tree Species of NGP'),
 (194,'10-001-02-00004-08-012-01','Project1','Maintenance of Clonal Nurseries'),
 (195,'10-001-02-00004-08-012-04','Project 4','Capacity Building and other related activities'),
 (196,'10-001-02-00004-08-012-04-01','Study1','Assessment of Field Performance of Planted Quality Materials for NGP'),
 (197,'10-001-02-00004-08-013','Proj.10','SAA'),
 (198,'10-001-02-00004-08-013-01','Activity1','2017 Plantation Establishment (ERDB-101-2017-04-205)'),
 (199,'10-001-02-00004-09','FDRP','Forest development, rehabilitation and protection'),
 (200,'10-001-02-00004-09-001','Proj.1','Forest Extension Officer'),
 (201,'10-001-02-00004-10','GAD','Gender and Development'),
 (202,'10-001-02-00004-10-001','Proj.1','Client Focused activities'),
 (203,'10-001-02-00004-10-001-01','Activity1','Pantas Aral'),
 (204,'10-001-02-00004-10-001-02','Activity 2','Gising Diwa for the youth'),
 (205,'10-001-02-00004-10-001-03','Activity 3','GADrich Newsletter'),
 (206,'10-001-02-00004-10-001-04','Activity 4','Gender-based MIS for R & D on ENR'),
 (207,'10-001-02-00004-10-001-05','Activity 5','Action Researchon GAD (Adopt-a- community)'),
 (208,'10-001-02-00004-10-001-06','Activity 6','Technical Assistance to non-ERDB personnel/ERDB clients'),
 (209,'10-001-02-00004-10-001-07','Activity 7','Technical assistance to other DENR sectors/offices in the review of existing offices'),
 (210,'10-001-02-00004-10-001-08','Activity 8','Review of Existing policies on ENR'),
 (211,'10-001-02-00004-10-001-09','Activity 9','Support to the Intrnational for a on sustainable enviroment strategies in SEA'),
 (212,'10-001-02-00004-10-001-10','Activity10','National Conference on Multi-Disciplinary Perspective on Gender and Sustainable Environment in the Philippines'),
 (213,'10-001-02-00004-10-002','Proj. 2','Organization-Focused activities'),
 (214,'10-001-02-00004-10-002-01','Activity1','Gender sensitivity and gender responsive training'),
 (215,'10-001-02-00004-10-002-02','Activity 2','GMEF and HGDG Analysis Tools Training'),
 (216,'10-001-02-00004-10-002-03','Activity 3','Monitoring of gender mainstreaming in ERDB RDE projects using HGDG'),
 (217,'10-001-02-00004-10-002-04','Activity 4','Health and wellness seminars'),
 (218,'10-001-02-00004-10-002-05','Activity 5','Women employees availed of local training (no.=3)'),
 (219,'10-001-02-00004-10-002-06','Activity 6','Inter-agency GADactivities/meetings/ seminars and conferences'),
 (220,'10-001-02-00004-10-002-07','Activity 7','Women\'s month celebration (WMC)'),
 (221,'10-001-02-00004-10-002-08','Activity 8','Basic office safety and health for women'),
 (222,'10-001-02-00004-10-002-09','Activity 9','Regular (quarterly), emergency, special, and committee meetings of ERDB GAD Focal Point System (FPS)'),
 (223,'10-001-02-00004-10-002-10','Activity10','Updating Database on basic office safely in ERDB workplace'),
 (224,'10-001-02-00004-11','Youth','ERDB\'s Youth Environment and Natural Resources Program in Responseto RA 9512'),
 (225,'10-001-02-00004-11-001','Proj.1','An act to promote environmental awareness through environmental education andother purposes'),
 (226,'10-001-02-00004-12','WWRRC','Watershed and Water Resources Research Center'),
 (227,'10-001-02-00004-12-001','Proj.1','Watershed resources assessment and hazards analysis'),
 (228,'10-001-02-00004-12-001-01','Study1','Resources Assessment of Critical Watersheds in Northern and Central Luzon'),
 (229,'10-001-02-00004-12-001-02','Study 2','Vulnerability Assessment of Critical Watersheds in Northern and Central Luzon'),
 (230,'10-001-02-00004-12-002','Proj. 2','Management and Protection of water bodies'),
 (231,'10-001-02-00004-12-002-01','Study1','Phytoremediation of Polluted Rivers within Priority Watersheds in Northern and Central Luzon'),
 (232,'10-001-02-00004-12-003','Proj. 3','Watershed rehabilitation, protection and conservation'),
 (233,'10-001-02-00004-12-003-01','Study1','Field performance of cloned indigenous forest tree species with mycorrhiza in degraded watershed'),
 (234,'10-001-02-00004-12-004','Proj. 4','Policy review/formulation/amendment and harmonization'),
 (235,'10-001-02-00004-12-004-01','Study1','Effectiveness of watershed management policy implementation in Northern and Central Luzon'),
 (236,'10-001-02-00004-12-005','Proj. 5','Integrated pest management development of economically important forest pests in CAR and Region 2'),
 (237,'10-001-02-00004-12-006','PMS','Mandatories/Project Management Service under R & D'),
 (238,'10-001-02-00004-12-007','Proj. 6','Packaging of ENR technologies for extension and production of IEC materials'),
 (239,'10-001-02-00004-12-007-01','Activity1','Technology assessment'),
 (240,'10-001-02-00004-12-007-02','Activity 2','Processing of assessed technologies for specific end users'),
 (241,'10-001-02-00004-12-007-03','Activity 3','Production of IEC materials'),
 (242,'10-001-02-00004-12-008','Proj. 7','Promotion and dissemination of technologies for sustainable ENR management'),
 (243,'10-001-02-00004-12-008-01','Activity1','IEC campaign for promotion of ENR technologies'),
 (244,'10-001-02-00004-12-008-02','Activity 2','Capacity-building for ENR clients'),
 (245,'10-001-02-00004-12-008-03','Activity 3','Participatory extension of ENR technologies through PARTNER-BOND strategy'),
 (246,'10-001-02-00004-12-008-04','Activity 4','Promotion of ENR technologies through demonstration areas and other strategies'),
 (247,'10-001-02-00004-12-009','Proj. 8','Monitoring and post evaluation of transferred ENR technologies'),
 (248,'10-001-02-00004-12-009-01','Activity1','Monitoring of ENR technology transfer activities'),
 (249,'10-001-02-00004-12-009-02','Activity 2','Post evaluation of ENR technologies'),
 (250,'10-001-02-00004-12-010','PMS-TTD','Project monitoring and supervision'),
 (251,'10-001-02-00004-12-011','GIYS','Support to GAD/IAS/YDO/Senior'),
 (252,'10-001-02-00004-12-012','Proj. 9','Clonal nursery and production of QPM of premium indigenous forest species for the NGP'),
 (253,'10-001-02-00004-12-012-01','Study1','Clones planting stock production'),
 (254,'10-001-02-00004-12-012-02','Study 2','Seedling production from quality seeds'),
 (255,'10-001-02-00004-12-012-03','Study 3','Quality seedlings produced by SUCs'),
 (256,'10-001-02-00004-12-012-04','Study 4','Maintenance of SPAs/IPTs and seed collection'),
 (257,'10-001-02-00004-12-012-05','Study 5','Maintenance of clonal facilities'),
 (258,'10-001-02-00004-12-012-06','Study 6','Maintenance/Operationalization of forest tree seed center'),
 (259,'10-001-02-00004-12-013','Proj.10','Project monitoring and supervision-NGP'),
 (260,'10-001-02-00004-12-014','Proj.11','ENR technology Extension Project'),
 (261,'10-001-02-00004-12-014-01','Activity1','Technology Needs Assessment'),
 (262,'10-001-02-00004-12-015','RA','Research Administration'),
 (263,'10-001-02-00004-12-015-01','Activity1','Project Monitoring and Supervision'),
 (264,'10-001-02-00004-12-015-02','Activity 2','Monitoring & Evaluation'),
 (265,'10-001-02-00004-12-015-03','Activity 3','Fixed Mandatories'),
 (266,'10-001-02-00004-12-016','Proj.12','Livehood Development within Watersheds'),
 (267,'10-001-02-00004-12-016-01','Study1','Comparative Analysis on the Production /Yield of Oleoresin Tapping Technology in Benguet Pine (Pinus kesiya Royle ex Grodon)'),
 (268,'10-001-02-00004-13','LAUFTeRC','Land Management, Agroforestry and Upland Farming Technology Research Center'),
 (269,'10-001-02-00004-13-001','Proj.1','Socio-economic impact of the implementation of the land distribution program through proclamation/ human settlement projects to some beneficiaries'),
 (270,'10-001-02-00004-13-001-01','Study1','Socio-economic assessment of beneficiaries and their perceptions on some land distribution programs/human settlement projects to some beneficiaries'),
 (271,'10-001-02-00004-13-001-02','Study 2','Benefit-cost analysis of the implementationof the \"Handog Titulo Program\"'),
 (272,'10-001-02-00004-13-001-03','Study 3','Biophysical studies for appropriate determination and allocation of land uses'),
 (273,'10-001-02-00004-13-002','Proj. 2','Development of Strategies in Establishing Agroforestry Demo Areas'),
 (274,'10-001-02-00004-13-002-01','Study1','Action Research on Agroforestry Systems Trials in CBFM Area in Labo, Camarines Norte'),
 (275,'10-001-02-00004-13-002-02','Study 2','Action Research on Agroforestry Systems Trials inLGU-managed Areas in Labo, Camarines Norte'),
 (276,'10-001-02-00004-13-003','Proj. 3','Sustainability of ExistingFarming Technologies'),
 (277,'10-001-02-00004-13-003-01','Study1','Sustainability of Existing Farming Technologies in Liliw, Laguna'),
 (278,'10-001-02-00004-13-003-02','Study 2','Sustainability of Existing Farming Technologies in Roxas, Palawan'),
 (279,'10-001-02-00004-13-003-03','Study 3','Macro-Somatic Propagation of Sambulauan (Syzygium albayense Merr.) using Stem Cuttings in Different Concentration of Indole-3 Butyric Acid'),
 (280,'10-001-02-00004-13-003-04','Study 4','Integration of high premium tree species with high yeilding pill varieties'),
 (281,'10-001-02-00004-13-004','Proj. 4','Adaptation Strategy Towards Resiliency of Community-Based Forest Management Systems to Climate Chang'),
 (282,'10-001-02-00004-13-004-01','Study1','Vulnerability assessment of CBFM area in Labo, Camarines Norte'),
 (283,'10-001-02-00004-13-004-02','Study 2','Awareness and perception on climate change in Espanola Palawan'),
 (284,'10-001-02-00004-13-004-03','Study 3','Enhanced Design and Planning for Climate-Smart Agroforestry Development in CBFM Areas'),
 (285,'10-001-02-00004-13-005','PMS','Project monitoring and supervision'),
 (286,'10-001-02-00004-13-005-01','Activity1','Attendance to Mancon'),
 (287,'10-001-02-00004-13-005-02','Activity 2','Conduct of Annual In-house Review'),
 (288,'10-001-02-00004-13-005-03','Activity 3','Attendance to conference/forum/training'),
 (289,'10-001-02-00004-13-005-04','Activity 4','Conduct of Senior Staff Quarterly Meeting'),
 (290,'10-001-02-00004-13-005-05','Activity 5','Conduct of HR Intervention/Seminar-worshop for Researchers'),
 (291,'10-001-02-00004-13-006','FE','Fixed Expenditures'),
 (292,'10-001-02-00004-13-007','Proj. 5','Packaging of ENR technologies and production of IEC materials'),
 (293,'10-001-02-00004-13-007-01','Activity1','Technology assessment'),
 (294,'10-001-02-00004-13-007-02','Activity 2','Processing of assessed technologies for specific end-users'),
 (295,'10-001-02-00004-13-008','Proj. 6','Promotion and dissemination of technologies for sustainable ENR management'),
 (296,'10-001-02-00004-13-008-01','Activity1','Production of IEC materials'),
 (297,'10-001-02-00004-13-008-02','Activity 2','IEC campaign for promotion of ENR technologies'),
 (298,'10-001-02-00004-13-008-03','Activity 3','Capacitation of stakeholders for LAUFTeRC clients'),
 (299,'10-001-02-00004-13-008-04','Activity 4','Participatory extension of ENR technologies through PARNET-BOND'),
 (300,'10-001-02-00004-13-008-05','Activity 5','Technology promotion through demonstration areas'),
 (301,'10-001-02-00004-13-009','Proj. 7','Monitoring and post evaluation of transferred ENR technologies'),
 (302,'10-001-02-00004-13-009-01','Activity1','Monitoring of ENR technology transfer extension activities'),
 (303,'10-001-02-00004-13-009-02','Activity 2','Post-evaluation of transferred ENR technologies'),
 (304,'10-001-02-00004-13-010','Proj. 8','Clonal nursery and production of quality planting materials'),
 (305,'10-001-02-00004-13-010-01','Activity1','Seedling production'),
 (306,'10-001-02-00004-13-010-02','Activity 2','Maintenance of SPAs/IPTs'),
 (307,'10-001-02-00004-13-010-03','Activity 3','Establishment, maintenance and Operationalization of Forest Tree Seed Center'),
 (308,'10-001-02-00004-13-010-04','Activity 4','Maintenance of Clonal Nuresry'),
 (309,'10-001-02-00004-13-011','PMS(2)','Project Mgt. & Supervision'),
 (310,'10-001-02-00004-13-012','Proj. 9','ENR technologyExtnsion Project'),
 (311,'10-001-02-00004-13-012-01','Activity1','Scoping and Linkaging'),
 (312,'10-001-02-00004-13-012-02','Activity 2','Capacity buidling for ERDB clients'),
 (313,'10-001-02-00004-13-012-03','Activity 3','IEC campaign for promotion of ENR technologies'),
 (314,'10-001-02-00004-13-012-04','Activity 4','Project Monitoring'),
 (315,'10-001-02-00004-13-012-05','Activity 5','Communication Planning'),
 (316,'10-001-02-00004-13-013','RA','Research Administrative'),
 (317,'10-001-02-00004-13-013-01','Activity1','PMS'),
 (318,'10-001-02-00004-13-013-02','Activity 2','M&E'),
 (319,'10-001-02-00004-13-013-03','Activity 3','Fixed Mandatories'),
 (320,'10-001-02-00004-14','BCWERC','Biodiversity, Coastal, Wetlands and Ecotourism Resource Center'),
 (321,'10-001-02-00004-14-001','Proj.1','Results-based Assessment of Rehabilitated Disaster Affected Mangrove and Beach Forest Areas)'),
 (322,'10-001-02-00004-14-002','Proj. 2','GIS-based resource inventory, vulnerability, assessment and impacts of climate change to smallisla'),
 (323,'10-001-02-00004-14-003','Proj. 3','Biodiversity profiling and carrying capacity determination of priority nature based ecotourism areas'),
 (324,'10-001-02-00004-14-004','Proj. 4','Inter-phasing vulnerability and CARCAP assessment of priority wetlands'),
 (325,'10-001-02-00004-14-005','Proj. 5','Development of Mangrovetum for Biodiversity Conservation Towards Ecotourism)'),
 (326,'10-001-02-00004-14-006','Proj. 6','Packaging of ENR Technologies'),
 (327,'10-001-02-00004-14-006-01','Activity1','Technology assessment'),
 (328,'10-001-02-00004-14-006-02','Activity 2','Processing of assessed technologies for specific end users'),
 (329,'10-001-02-00004-14-007','Proj. 7','Promotion and dissemination of technologies for sustainable ENR management'),
 (330,'10-001-02-00004-14-007-01','Activity1','Production of IEC materials'),
 (331,'10-001-02-00004-14-007-02','Activity 2','IEC campaign for promotion of ENR technologies'),
 (332,'10-001-02-00004-14-007-03','Activity 3','Capacity building of ERDB-BCWERC clients'),
 (333,'10-001-02-00004-14-007-04','Activity 4','Participatory extension of ENR technologies through PARTNER-BOND'),
 (334,'10-001-02-00004-14-007-05','Activity 5','Promotion of ENR technologies through demonstration areas'),
 (335,'10-001-02-00004-14-007-06','Activity 6','Conduct of Annual in-house review'),
 (336,'10-001-02-00004-14-008','Proj. 8','Monitoring and post evaluation of transferred ENR technologies'),
 (337,'10-001-02-00004-14-008-01','Activity1','Monitoring of ENR technology transfer ENR technologies'),
 (338,'10-001-02-00004-14-008-02','Activity 2','Post evaluation of transferred ENR technologies'),
 (339,'10-001-02-00004-14-009','Proj. 9','National Greening Program'),
 (340,'10-001-02-00004-14-009-01','Activity1','Production of cloned seedlings'),
 (341,'10-001-02-00004-14-009-02','Activity 2','Production of seedlings from quality seeds'),
 (342,'10-001-02-00004-14-009-03','Activity 3','Production of clones/seedlings by SUC\'s'),
 (343,'10-001-02-00004-14-009-04','Activity 4','Maintenance of seed sources SPA/IPTs and seed collection'),
 (344,'10-001-02-00004-14-009-05','Activity 5','Maintenance of tree seed center'),
 (345,'10-001-02-00004-14-009-06','Activity 6','Maintenance of Clonal Nurseries'),
 (346,'10-001-02-00004-14-010','PMS','Project monitoring and supervision'),
 (347,'10-001-02-00004-14-010-01','Activity1','RDE'),
 (348,'10-001-02-00004-14-010-02','Activity 2','TTES'),
 (349,'10-001-02-00004-14-010-03','Activity 3','Clonal'),
 (350,'10-001-02-00004-14-011','ME','Mandatory Expenses'),
 (351,'10-001-02-00004-14-011-01','Activity1','RDE'),
 (352,'10-001-02-00004-14-011-02','Activity 2','TTES'),
 (353,'10-001-02-00004-14-012','GAD','Gender and Development'),
 (354,'10-001-02-00004-14-013','Proj.10','ENR technology Extension Project'),
 (355,'10-001-02-00004-14-013-01','Activity1','Scoping and Linkaging'),
 (356,'10-001-02-00004-14-013-02','Activity 2','Capacity Building for ERDB Clients'),
 (357,'10-001-02-00004-14-013-03','Activity 3','Project Monitoring'),
 (358,'10-001-02-00004-14-013-04','Activity 4','Communication Planning'),
 (359,'10-001-02-00004-14-014','Res Admin','Research Administrative'),
 (360,'10-001-02-00004-14-014-01','Activity1','PMS'),
 (361,'10-001-02-00004-14-014-02','Activity 2','M&E'),
 (362,'10-001-02-00004-14-014-03','Activity 3','Fixed Mandatories'),
 (363,'10-001-02-00004-14-015','Prioj.11','Interphasing Vulnerability and CARCAP Assessment of Priority Nature-based Ecotourism Areas'),
 (364,'10-001-02-00004-14-015-01','Study1','GIS-based Vulnerability Assessment of Nature-based Ecotourism Areas Anchored on the Climate Change Framework Climate Change Framework'),
 (365,'10-001-02-00004-14-015-02','Study 2','Biodiversity Profiling and Carrying CapacityDetermination of Priority Nature-based Ecotourism Areas'),
 (366,'10-001-02-00004-15','FTRRC','Forest and Timber Resources Research Center'),
 (367,'10-001-02-00004-15-001','Proj.1','Tree improvement and development of high quality planting materials of indigenous tree species and industrial tree plantations (ITP) species'),
 (368,'10-001-02-00004-15-001-01','Activity1','Second Generation of progeny Field Trial Development of Mangium in Northern Mindanao'),
 (369,'10-001-02-00004-15-001-02','Activity 2','Maintenance and protection of established seed sources/seedling seed orchards and clonal seed orchard'),
 (370,'10-001-02-00004-15-001-02-1','Comp1','Growth and Genetic Variation of First Generation Progenies of Some Industrial Tree Plantation Species in Northern Mindanao'),
 (371,'10-001-02-00004-15-001-02-2','Comp 2','Growth and Genetic Variation of First Generation Progenies of Some Industrial Tree Plantation Species in Eastern Mindanao'),
 (372,'10-001-02-00004-15-001-02-3','Comp 3','Genetic Variation of Falcata (Falcataria mollucana) resistant to Gall Rust and pink canker'),
 (373,'10-001-02-00004-15-002','Proj. 2','Development of integrated pest management for ITP in response to climate change'),
 (374,'10-001-02-00004-15-003','Proj. 3','Other Priority Projects'),
 (375,'10-001-02-00004-15-003-01','PMS','Project monitoring and supervision'),
 (376,'10-001-02-00004-15-003-02','OCH','Office of the Center Head'),
 (377,'10-001-02-00004-15-004','Proj. 4','Technology transfer and extension services for sustainable management of natural and plantation fore'),
 (378,'10-001-02-00004-15-004-01','Activity1','Packaging of ENR technologies for IEC production and extension'),
 (379,'10-001-02-00004-15-004-02','PMS','Project monitoring and supervision'),
 (380,'10-001-02-00004-15-005','Proj. 5','Clonal nursery/production of QPM'),
 (381,'10-001-02-00004-15-005-01','Activity1','Production of QPM from clones'),
 (382,'10-001-02-00004-15-005-02','Activity 2','Production of QPM from seedlings'),
 (383,'10-001-02-00004-15-005-03','Activity 3','Production of cloned seedlings by SUC'),
 (384,'10-001-02-00004-15-005-04','Activity 4','Maintenance of SPA/seed collection'),
 (385,'10-001-02-00004-15-005-05','Activity 5','Maintenance and protection of Mindanao tree seed center'),
 (386,'10-001-02-00004-15-005-06','Activity 6','Project monitoring and supervision'),
 (387,'10-001-02-00004-15-006','Proj. 6','Maintenance of Clonal Facilities'),
 (388,'10-001-02-00004-15-006-01','Activity1','Repair and maintenance of clonal facilities/improvement of clonal infrastructures'),
 (389,'10-001-02-00004-15-007','Proj.7','Conservation strategy on valuable and threatened indigenous forest tree species'),
 (390,'10-001-02-00004-15-007-01','Study1','In-situ and Ex-situ Conservation of Igem and Almaciga Species in Mindanao'),
 (391,'10-001-02-00004-15-007-02','Study 2','Domestication of Some Native Tree Species'),
 (392,'10-001-02-00004-15-008','RA','Research Administrative'),
 (393,'10-001-02-00004-15-008-01','Activity1','PMS'),
 (394,'10-001-02-00004-15-008-02','Activity 2','M&E'),
 (395,'10-001-02-00004-15-008-03','Activity 3','Fixed Mandatories'),
 (396,'10-001-02-00004-16','MDARRC','Mining and Degraded Areas Rehabilitation Research Center'),
 (397,'10-001-02-00004-16-001','Proj.1','Generation and development of technologies for the rehabilitation of multiple use zone protected areas'),
 (398,'10-001-02-00004-16-002','Proj. 2','Generation and development of technologies for the rehabilitation of degraded community based forest management (CBFM) area'),
 (399,'10-001-02-00004-16-003','Proj. 3','Generation and development of technologies for the rehabilitation of mined-waste areas'),
 (400,'10-001-02-00004-16-003-01','Study1','Perfomance of Different Cloned Climax Speceis Interplanted in Existing Tree Condition within Mined-Out Areas of CCC'),
 (401,'10-001-02-00004-16-004','Proj. 4','Generation and development of technologies for the rehabilitation of degraded mangrove areas'),
 (402,'10-001-02-00004-16-004-01','Study1','Rehabilitation of degraded mangrove areas using 3 mangrove species in exposed mangrove areas in Davao Oriental'),
 (403,'10-001-02-00004-16-004-02','Study 2','Improving survival of planted mangrove seedlings in exposed areas using bamboo as wave attenuators'),
 (404,'10-001-02-00004-16-005','Proj. 5','National watershed management in the Philippines (Phase 2) Saug watershed'),
 (405,'10-001-02-00004-16-006','Proj. 6','Support to RDE, Operations and Activities'),
 (406,'10-001-02-00004-16-006-01','Activity1','Maintenance of Research station and experimental area'),
 (407,'10-001-02-00004-16-006-02','Activity 2','Annual In-house Review'),
 (408,'10-001-02-00004-16-006-03','Activity 3','Membership to Regional Consortium'),
 (409,'10-001-02-00004-16-006-04','Activity 4','Participation/Attendance to Trainings/Conferences/Meetings'),
 (410,'10-001-02-00004-16-006-05','Activity 5','Project Monitoring and Supervision'),
 (411,'10-001-02-00004-16-007','Proj. 7','Clonal Nursery and production of quality planting materials'),
 (412,'10-001-02-00004-16-007-01','Activity1','Production of premium indigenous seedlings (Clones and Seedlings)'),
 (413,'10-001-02-00004-16-007-02','Activity 2','Maintenance of seed production area (SPA) including seed collection'),
 (414,'10-001-02-00004-16-007-03','Activity 3','Maintenance and operationalization of forest tree seed center (FTSC)'),
 (415,'10-001-02-00004-16-007-04','Activity 4','Rehabilitation of Clonal Facility'),
 (416,'10-001-02-00004-16-007-05','Activity 5','Maintenance of Clonal Nursery Complex (Region11 &12)'),
 (417,'10-001-02-00004-16-008','PMS','Project Monitoring and Supervision'),
 (418,'10-001-02-00004-16-009','Proj. 8','Packaging of ENR technologies and extension'),
 (419,'10-001-02-00004-16-009-01','Activity1','Technology assessment'),
 (420,'10-001-02-00004-16-009-02','Activity 2','Processing of assessed technologies'),
 (421,'10-001-02-00004-16-010','Proj. 9','Promotion and dissemination of technologies for sustainable ENR management'),
 (422,'10-001-02-00004-16-010-01','Activity1','Production of IEC materials'),
 (423,'10-001-02-00004-16-010-02','Activity 2','IEC campaign for promotion of ENR technologies'),
 (424,'10-001-02-00004-16-010-03','Activity 3','Capacity building for MDARRC clients (Degraded Areas Rehabilitation Technologies and Propagation of Forest Trees)'),
 (425,'10-001-02-00004-16-010-04','Activity 4','Participatory extension of ENR technologies through PARTNER BOND'),
 (426,'10-001-02-00004-16-010-05','Activity 5','Production of ENR technologies through demonstration areas'),
 (427,'10-001-02-00004-16-011','Proj.10','Monitoring and post evaluation of transferred ENR technologies'),
 (428,'10-001-02-00004-16-011-01','Activity1','Monitoring of ENR technology transfer and extension activities'),
 (429,'10-001-02-00004-16-011-02','Activity 2','Post-evaluation of transferred ENR technologies'),
 (430,'10-001-02-00004-16-012','Proj.11','ENR technology Extension Project'),
 (431,'10-001-02-00004-16-012-01','Activity1','Scoping and Linkaging'),
 (432,'10-001-02-00004-16-012-02','Activity 2','Capacity Building for ERDB Clients'),
 (433,'10-001-02-00004-16-012-03','Activity 3','Project Monitoring'),
 (434,'10-001-02-00004-16-012-04','Activity 4','Communication Planning'),
 (435,'10-001-02-00004-16-012-05','Activity 5','IEC campaign forPromotion of ENR Technologies'),
 (436,'10-001-02-00004-16-013','Res Admn','Research Administration'),
 (437,'10-001-02-00004-16-013-01','Activity1','Project Monitoring and Supervision'),
 (438,'10-001-02-00004-16-013-02','Activity 2','Fixed Mandatories'),
 (439,'10-001-02-00004-16-014','Proj.12','Performance of Different Cloned Climax Species Interplanted in Existing Tree Plantation within Mined-Out Areas of Carmen Copper Corporation'),
 (440,'10-001-02-00004-16-015','Proj.13','Generation and Development of Technologies for the Rehabilitation of Degraded Ancestral Domain Areas, Community-Based Forest Management Areas and Mult'),
 (441,'10-001-02-00004-17','UTHRC','Urban, Toxic Substances and Hazardous Wastes Research Center'),
 (442,'10-001-02-00004-17-001','Proj.1','R & D for the management and abatement of pollution towards the attainment of green cities'),
 (443,'10-001-02-00004-17-001-01','Study1','Ecosystems perspective in zoning and land use planning in highly urbanized areas in NCR'),
 (444,'10-001-02-00004-17-001-02','Study 2','Phytoremediation schemes for polluted waterways and waste reservoir in Las Pi?as and Para?aque'),
 (445,'10-001-02-00004-17-001-03','Study 3','Settlement processes and determination of ESWM scheme in selected resettlement areas in NCR'),
 (446,'10-001-02-00004-17-001-04','Study 4','Application of green technologies to brace communities against impacts of urbanization in the National Capital Region'),
 (447,'10-001-02-00004-17-001-05','Study 5','Assessment of selected LGU-managed green parks and recreational areas in NCR'),
 (448,'10-001-02-00004-17-001-06','Activity1','Support to Oprations (Office of the Center Head)'),
 (449,'10-001-02-00004-17-001-07','Activity 2','PMS'),
 (450,'10-001-02-00004-17-002','Proj. 2','R & D on integrated management of TS and HW'),
 (451,'10-001-02-00004-17-003','Proj. 3','Packaging of ENR technologies for extension and production of IEC materials'),
 (452,'10-001-02-00004-17-003-01','Activity1','Technology assessment'),
 (453,'10-001-02-00004-17-003-02','Activity 2','Processing of assessed technologies for specific end-users'),
 (454,'10-001-02-00004-17-004','Proj. 4','Promotion and dissemination of technologies for sustainableENR management'),
 (455,'10-001-02-00004-17-004-01','Activity1','Production of IEC materials'),
 (456,'10-001-02-00004-17-004-02','Activity 2','IEC campaign for promotion of ENR technologies'),
 (457,'10-001-02-00004-17-004-03','Activity 3','Capacitation of stakeholders as special extension service providers or ENR agents of change'),
 (458,'10-001-02-00004-17-004-04','Activity 4','Participatory extension of ENR technologies through PARTNER-BOND'),
 (459,'10-001-02-00004-17-004-05','Activity 5','Promotion of ENR technologies through demonstration areas'),
 (460,'10-001-02-00004-17-005','Proj. 5','Monitoring and post-evaluation of transferred ENR technologies'),
 (461,'10-001-02-00004-17-006','PMS','Project Monitoring and Supervision'),
 (462,'10-001-02-00004-17-007','Proj. 6','National Greening Program'),
 (463,'10-001-02-00004-17-007-01','Activity1','Production of Premium/Indigenous Species'),
 (464,'10-001-02-00004-17-007-02','Activity 2','Maintenance of Clonal Nursery'),
 (465,'10-001-02-00004-17-008','Proj. 7','R&D on Remediation Technologies for the Reduction of Pollution from Toxic Substances and Hazardous W'),
 (466,'10-001-02-00004-17-008-01','Study1','Degradation of polyethylene, polypropylene and polysterene plastic using indigenous bacteria'),
 (467,'10-001-02-00004-17-009','Proj. 8','ENR Technology Extension Project'),
 (468,'10-001-02-00004-17-009-01','Activity1','Scoping and Linkaging'),
 (469,'10-001-02-00004-17-009-02','Activity 2','Capacity Building for ERDB UTHRC clients'),
 (470,'10-001-02-00004-17-009-03','Activity 3','IEC campaign for promotion of ENR Technologies'),
 (471,'10-001-02-00004-17-009-04','Activity 4','Project Monitoring'),
 (472,'10-001-02-00004-17-009-05','Activity 5','Communication Planning'),
 (473,'10-001-02-00004-17-009-06','Activity 6','Technology Needs Assessment'),
 (474,'10-001-02-00004-17-010','Res Ad','Research Administration'),
 (475,'10-001-02-00004-17-010-01','PMS','Project Monitoring and Supervision'),
 (476,'10-001-02-00004-17-010-02','M&E','Monitoring and Evaluation'),
 (477,'10-001-02-00004-17-010-03','FM','Fixed Mandatories'),
 (478,'10-001-02-00004-18','IAFT','Inter-Agency Fund Transfer'),
 (479,'10-001-02-00004-18-001','MGB','Mines and Geosciences Bureau'),
 (480,'10-001-02-00004-18-001-01','Proj.1','ERDB-MGB Projects on Ecosystems Reconstruction & Phytoremediation of Mined-Out Lands'),
 (481,'10-001-02-00004-18-002','PCAARRD','Philippine Council for Agriculture, Forestry and Natural Resources Research and Development'),
 (482,'10-001-02-00004-18-002-01','Proj.1','National Research and Development Project for Watershed Management in the Philippines (Phase II) Saug Watershed'),
 (483,'10-001-02-00004-18-006','ERDB','Various Trust Fund'),
 (484,'10-001-02-00004-18-006-01','K4','K4 Fund'),
 (485,'10-001-02-00004-18-006-02','SC','Sylvatrop Contribution from Members'),
 (486,'10-001-02-00004-19','MBFDP','Mangrove Beach Forest Development Project'),
 (487,'10-001-02-00004-20','SC','Sylvatrop Contribution'),
 (488,'10-001-02-00004-21','NRDP','National Research and Development Project'),
 (489,'10-001-02-00004-22','SAA-PMISU','Allotment for the conduct of Orientation-Workshop on ERDIS, ETGIS and M & E (SAA NO.: ERDB-101-2016-08-880)'),
 (490,'10-001-02-00004-23','SAA-UPLB','Integrated R & D for high value forest crops and refurbishment of clonal nursery/facility - UPLB (SAA NO.: ERDB-101-2016-08-886)'),
 (491,'10-001-02-00004-24','SAA-KISS','Procurement of Desktop Computers for RC (SAA NO.: ERDB-101-2016-09-1036);(CONTG)'),
 (492,'10-001-02-00004-25','PCAARRD-GIA','DEVELOPMENT OF MICROPROPAGATION PROTOCOL FOR FOUR ECONOMICALLY IMPORTANT BAMBOO SPECIES IN THE PHILI'),
 (493,'10-001-02-00004-26','PCAARRD-CACAO','Rubber, Coffe & Cacao: Bilding Site Matching Functions for Improved Upland Development'),
 (494,'10-001-02-00004-27','NBW-2K16','National Biotechnology Week 2016 (SAA NO.: ERDB-101-2016-11-1224)'),
 (495,'10-001-02-00004-28','SAA-FG','Allotment for the hiring og (6) Forest Guard/Rangers (SAA NO.: ERDB-101-2016-11-1222)'),
 (496,'10-001-02-00004-29','BAMPDP','Bamboo and Mangrove Plantation Development Project (SAA NO.: ERDB-101-2016-11-1294)'),
 (497,'10-001-02-00004-30','IBT','Post-Assessment of the 2016 DENR Inter-Bureau Tournament (SAA NO.: ERDB-101-2016-12-1401)'),
 (498,'10-001-02-00004-31','BVT','Post-Tournament Assessment of DENR Basketball & Volleyball Team(SAA NO.: ERDB-101-2016-12-1386)'),
 (499,'10-001-02-00004-32','INREM','International Conference on Integrated Natural Resources and Environmental Managemant (SAA NO.: ERDB-101-2016-12-1417)'),
 (500,'10-001-02-00004-33','SPF','Special Purpose Fund'),
 (501,'10-001-02-00004-33-001','MPBF','Miscellaneuos Personnel Benefit Fund'),
 (502,'10-001-02-00004-33-001-01','PS 2017','Additional PS 2017'),
 (503,'10-001-02-00004-33-002','GCF','Green Climate Fund (SAA NO.101-2017-03-141)'),
 (504,'10-001-02-00004-33-003','RLIP','Retirement and Life Insurance Premium'),
 (505,'10-001-02-00004-34','SP','Special Project'),
 (506,'10-001-02-00004-34-001','Proj.1','National Survey and Development of an Integraded Pest Management Strategy for Important Pests in the Philippines'),
 (507,'10-001-02-00004-34-002','eNGP-Bamboo','Bamboo Plantation Development Project (BPDP) under Enhanced National Greening Program'),
 (508,'10-001-02-00004-34-003','eNGP-Mangrove','Mangrove and Beach Forest Development Project under Enhanced National Greening Program for Non-Yolan'),
 (509,'10-001-02-00004-34-004','Yolanda-Mangrove','Mangrove and Beach Forest Development Project (MBFDP) under the National Risk Reduction and Management Fund - Yolanda Rehabilitation and Reconstructio'),
 (510,'10-001-02-00004-34-005','ERDIS-RGIS-M&E','Budgetary requirements for the Training and Roll-out/Implementation of ERDIS-TGIS-M&E'),
 (511,'10-001-02-00004-34-006','STIPEND','Monthly Stipend and Travel Expenses for the Face-to-Face Session of Mr. Edmichael DG. Figueroa and Mr. Joselito T. Sumabat (SAA NO.:ERDB-101-2017-07-4'),
 (512,'10-001-02-00004-34-007','MPEF','Maintenance and Protection of Experimental Forests (SAA NO.:ERDB-101-2017-07-498)'),
 (513,'10-001-02-00004-34-008','MP-FM','Re-establishment of 460 hectares fire-damaged 2015 ERDB NGP sites and 3rd Year Maintenance and Protection of the remaining110 hectares undamaged port'),
 (514,'10-001-02-00004-34-009','NBW','National Bio-Technology Week'),
 (515,'10-001-02-00004-34-009-01','NBW 2017','National Bio-Technology Week 2017'),
 (516,'10-001-02-00004-34-010','ASRS','Training and Roll-out of the Automated Statistical Report System (SAA NO.: ERDB-101-2017-11-903)'),
 (517,'10-001-02-00004-34-011','MBCO','Enhancing the Manila Bay Strategy through information Convergence and Application of GIS and Remote Sensing Technologies (SAA NO.: ERDB-101-2017-11-10'),
 (518,'10-001-02-00004-34-012','YEATS','Year-end Assessment and Target Setting for 2018 for Solid Waste Management, Local Government and Indigenous Peoples\' Concerns and for Region 5(SAA NO.'),
 (519,'10-001-02-00004-34-013','YEAAS','Year-end Assessment of Advocacy Strategies of the Legislative Liaison System Climate Change Adaption, Mitigation and Disaster Risk Reduction Cluster ('),
 (520,'10-001-02-0004-18-003','PRRC','Pasig River Rehabilitaion Commission'),
 (521,'10-001-02-0004-18-003-01','Proj.1','Biodiversity Assessment of Pasig River'),
 (522,'10-001-02-0004-18-004','NPC','National Power Corporation'),
 (523,'10-001-02-0004-18-004-01','Proj.1','Establishment of Hydological Stations in NPC-Managed Watershed Reservation'),
 (524,'10-001-02-0004-18-005','PAWB','Protected Areas and Wildlife Bureau'),
 (525,'10-001-02-0004-18-005-01','Proj.1','Center for Agriculture and Biosciences International (CABI-IAS)');
/*!40000 ALTER TABLE `responsibility_center` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
